/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.transport.RequestTimedOutIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsTimeoutTest
extends EmbeddedBrokerTestSupport {
    static final Logger LOG = LoggerFactory.getLogger(JmsTimeoutTest.class);
    private final int messageSize = 65536;
    private final int messageCount = 10000;
    private final AtomicInteger exceptionCount = new AtomicInteger(0);

    public void testBlockedProducerConnectionTimeout() throws Exception {
        final ActiveMQConnection cx = (ActiveMQConnection)this.createConnection();
        final ActiveMQDestination queue = this.createDestination("testqueue");
        cx.setSendTimeout(10000);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Sender thread starting");
                    Session session = cx.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.setDeliveryMode(2);
                    TextMessage message = session.createTextMessage(JmsTimeoutTest.this.createMessageText());
                    for (int count = 0; count < 10000; ++count) {
                        producer.send((Message)message);
                    }
                    LOG.info("Done sending..");
                }
                catch (JMSException e) {
                    if (e.getCause() instanceof RequestTimedOutIOException) {
                        JmsTimeoutTest.this.exceptionCount.incrementAndGet();
                    } else {
                        e.printStackTrace();
                    }
                    return;
                }
            }
        };
        cx.start();
        Thread producerThread2 = new Thread(r);
        producerThread2.start();
        producerThread2.join(30000L);
        cx.close();
        JmsTimeoutTest.assertTrue((String)"No exception from the broker", (this.exceptionCount.get() > 0 ? 1 : 0) != 0);
    }

    public void testBlockedProducerUsageSendFailTimeout() throws Exception {
        final ActiveMQConnection cx = (ActiveMQConnection)this.createConnection();
        final ActiveMQDestination queue = this.createDestination("testqueue");
        this.broker.getSystemUsage().setSendFailIfNoSpaceAfterTimeout(5000L);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Sender thread starting");
                    Session session = cx.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.setDeliveryMode(2);
                    TextMessage message = session.createTextMessage(JmsTimeoutTest.this.createMessageText());
                    for (int count = 0; count < 10000; ++count) {
                        producer.send((Message)message);
                    }
                    LOG.info("Done sending..");
                }
                catch (JMSException e) {
                    if (e instanceof ResourceAllocationException || e.getCause() instanceof RequestTimedOutIOException) {
                        JmsTimeoutTest.this.exceptionCount.incrementAndGet();
                    } else {
                        e.printStackTrace();
                    }
                    return;
                }
            }
        };
        cx.start();
        Thread producerThread2 = new Thread(r);
        producerThread2.start();
        producerThread2.join(30000L);
        cx.close();
        JmsTimeoutTest.assertTrue((String)"No exception from the broker", (this.exceptionCount.get() > 0 ? 1 : 0) != 0);
    }

    @Override
    protected void setUp() throws Exception {
        this.exceptionCount.set(0);
        this.bindAddress = "tcp://localhost:0";
        this.broker = this.createBroker();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x500000L);
        super.setUp();
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
    }

    private String createMessageText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<filler>");
        for (int i = buffer.length(); i < 65536; ++i) {
            buffer.append('X');
        }
        buffer.append("</filler>");
        return buffer.toString();
    }
}

