/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.NetworkConnector;

public class NetworkRemovesSubscriptionsTest
extends TestCase {
    private static final String frontEndAddress = "tcp://0.0.0.0:61617";
    private static final String backEndAddress = "tcp://0.0.0.0:61616";
    private static final String TOPIC_NAME = "TEST_TOPIC";
    private BrokerService frontEnd;
    private BrokerService backEnd;
    private final ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://0.0.0.0:61617");
    private final ActiveMQTopic topic = new ActiveMQTopic("TEST_TOPIC");

    public void testWithSessionAndSubsciberClose() throws Exception {
        TopicConnection connection = this.connectionFactory.createTopicConnection();
        connection.start();
        for (int i = 0; i < 100; ++i) {
            TopicSession subscriberSession = connection.createTopicSession(false, 1);
            TopicSubscriber subscriber = subscriberSession.createSubscriber((Topic)this.topic);
            DummyMessageListener listener = new DummyMessageListener();
            subscriber.setMessageListener((MessageListener)listener);
            subscriber.close();
            subscriberSession.close();
        }
        connection.close();
        Thread.sleep(1000L);
        Destination dest = (Destination)this.backEnd.getRegionBroker().getDestinationMap().get(this.topic);
        NetworkRemovesSubscriptionsTest.assertNotNull((Object)dest);
        NetworkRemovesSubscriptionsTest.assertTrue((boolean)dest.getConsumers().isEmpty());
    }

    public void testWithSessionCloseOutsideTheLoop() throws Exception {
        TopicConnection connection = this.connectionFactory.createTopicConnection();
        connection.start();
        TopicSession subscriberSession = connection.createTopicSession(false, 1);
        for (int i = 0; i < 100; ++i) {
            TopicSubscriber subscriber = subscriberSession.createSubscriber((Topic)this.topic);
            DummyMessageListener listener = new DummyMessageListener();
            subscriber.setMessageListener((MessageListener)listener);
            subscriber.close();
        }
        subscriberSession.close();
        connection.close();
        Thread.sleep(1000L);
        Destination dest = (Destination)this.backEnd.getRegionBroker().getDestinationMap().get(this.topic);
        NetworkRemovesSubscriptionsTest.assertNotNull((Object)dest);
        NetworkRemovesSubscriptionsTest.assertTrue((boolean)dest.getConsumers().isEmpty());
    }

    public void testWithOneSubscriber() throws Exception {
        TopicConnection connection = this.connectionFactory.createTopicConnection();
        connection.start();
        TopicSession subscriberSession = connection.createTopicSession(false, 1);
        TopicSubscriber subscriber = subscriberSession.createSubscriber((Topic)this.topic);
        DummyMessageListener listener = new DummyMessageListener();
        subscriber.setMessageListener((MessageListener)listener);
        subscriber.close();
        subscriberSession.close();
        connection.close();
        Thread.sleep(1000L);
        Destination dest = (Destination)this.backEnd.getRegionBroker().getDestinationMap().get(this.topic);
        NetworkRemovesSubscriptionsTest.assertNotNull((Object)dest);
        NetworkRemovesSubscriptionsTest.assertTrue((boolean)dest.getConsumers().isEmpty());
    }

    public void testWithoutSessionAndSubsciberClose() throws Exception {
        TopicConnection connection = this.connectionFactory.createTopicConnection();
        connection.start();
        for (int i = 0; i < 100; ++i) {
            TopicSession subscriberSession = connection.createTopicSession(false, 1);
            TopicSubscriber subscriber = subscriberSession.createSubscriber((Topic)this.topic);
            NetworkRemovesSubscriptionsTest.assertNotNull((Object)subscriber);
        }
        connection.close();
        Thread.sleep(1000L);
        Destination dest = (Destination)this.backEnd.getRegionBroker().getDestinationMap().get(this.topic);
        NetworkRemovesSubscriptionsTest.assertNotNull((Object)dest);
        NetworkRemovesSubscriptionsTest.assertTrue((boolean)dest.getConsumers().isEmpty());
    }

    public void testWithoutSessionAndSubsciberClosePlayAround() throws Exception {
        TopicConnection connection = this.connectionFactory.createTopicConnection();
        connection.start();
        for (int i = 0; i < 100; ++i) {
            TopicSession subscriberSession = connection.createTopicSession(false, 1);
            TopicSubscriber subscriber = subscriberSession.createSubscriber((Topic)this.topic);
            DummyMessageListener listener = new DummyMessageListener();
            subscriber.setMessageListener((MessageListener)listener);
            if (i == 50) continue;
            subscriber.close();
            subscriberSession.close();
        }
        connection.close();
        Thread.sleep(1000L);
        Destination dest = (Destination)this.backEnd.getRegionBroker().getDestinationMap().get(this.topic);
        NetworkRemovesSubscriptionsTest.assertNotNull((Object)dest);
        NetworkRemovesSubscriptionsTest.assertTrue((boolean)dest.getConsumers().isEmpty());
    }

    protected void setUp() throws Exception {
        this.backEnd = new BrokerService();
        this.backEnd.setBrokerName("backEnd");
        this.backEnd.setPersistent(false);
        NetworkConnector backEndNetwork = this.backEnd.addNetworkConnector("static://tcp://0.0.0.0:61617");
        backEndNetwork.setName("backEndNetwork");
        backEndNetwork.setDynamicOnly(true);
        this.backEnd.addConnector(backEndAddress);
        this.backEnd.start();
        this.frontEnd = new BrokerService();
        this.frontEnd.setBrokerName("frontEnd");
        this.frontEnd.setPersistent(false);
        NetworkConnector frontEndNetwork = this.frontEnd.addNetworkConnector("static://tcp://0.0.0.0:61616");
        frontEndNetwork.setName("frontEndNetwork");
        this.frontEnd.addConnector(frontEndAddress);
        this.frontEnd.start();
        Thread.sleep(2000L);
    }

    protected void tearDown() throws Exception {
        if (this.backEnd != null) {
            this.backEnd.stop();
        }
        if (this.frontEnd != null) {
            this.frontEnd.stop();
        }
    }

    class DummyMessageListener
    implements MessageListener {
        DummyMessageListener() {
        }

        public void onMessage(Message arg0) {
        }
    }
}

