/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import java.util.ArrayList;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.perf.PerfConsumer;
import org.apache.activemq.perf.PerfProducer;
import org.apache.activemq.perf.SimpleNetworkTest;

public class SimpleNonPersistentQueueNetworkTest
extends SimpleNetworkTest {
    @Override
    protected void setUp() throws Exception {
        this.numberOfDestinations = 20;
        super.setUp();
    }

    @Override
    protected PerfProducer createProducer(ConnectionFactory fac, Destination dest, int number, byte[] payload) throws JMSException {
        PerfProducer pp = new PerfProducer(fac, dest, payload);
        pp.setDeliveryMode(1);
        return pp;
    }

    @Override
    protected PerfConsumer createConsumer(ConnectionFactory fac, Destination dest, int number) throws JMSException {
        PerfConsumer consumer = new PerfConsumer(fac, dest);
        boolean enableAudit = this.numberOfConsumers <= 1;
        System.out.println("Enable Audit = " + enableAudit);
        consumer.setEnableAudit(false);
        return consumer;
    }

    @Override
    public void testPerformance() throws JMSException, InterruptedException {
        super.testPerformance();
    }

    @Override
    protected Destination createDestination(Session s, String destinationName) throws JMSException {
        return s.createQueue(destinationName);
    }

    @Override
    protected void configureBroker(BrokerService answer) throws Exception {
        answer.setPersistent(false);
        answer.setMonitorConnectionSplits(true);
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        PolicyEntry entry = new PolicyEntry();
        entry.setQueue(">");
        entry.setMemoryLimit(0x6400000L);
        entry.setOptimizedDispatch(true);
        entry.setProducerFlowControl(true);
        entry.setMaxPageSize(10);
        entry.setLazyDispatch(false);
        policyEntries.add(entry);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(policyEntries);
        answer.setDestinationPolicy(policyMap);
        super.configureBroker(answer);
    }
}

