/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CRLTest {
    BrokerService broker;

    @Before
    public void setup() throws Exception {
        this.broker = BrokerFactory.createBroker((String)"xbean:src/test/resources/org/apache/activemq/security/activemq-revoke.xml");
        this.broker.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void testCRL() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", "src/test/resources/org/apache/activemq/security/client.ts");
        System.setProperty("javax.net.ssl.trustStorePassword", "password");
        System.setProperty("javax.net.ssl.trustStoreType", "jks");
        System.setProperty("javax.net.ssl.keyStore", "src/test/resources/org/apache/activemq/security/activemq-revoke.jks");
        System.setProperty("javax.net.ssl.keyStorePassword", "password");
        System.setProperty("javax.net.ssl.keyStoreType", "jks");
        boolean failed = false;
        try {
            this.basicSendReceive("ssl://localhost:61617");
        }
        catch (Exception e) {
            failed = true;
        }
        TestCase.assertTrue((String)"Send should have failed", (boolean)failed);
    }

    public void basicSendReceive(String uri) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        connection.start();
        String body = "hello world!";
        Queue destination = session.createQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send((Message)session.createTextMessage(body));
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Message received = consumer.receive(2000L);
        TestCase.assertEquals((String)body, (String)((TextMessage)received).getText());
    }
}

