/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InactivityMonitorTest
extends CombinationTestSupport
implements TransportAcceptListener {
    private static final Logger LOG = LoggerFactory.getLogger(InactivityMonitorTest.class);
    public Runnable serverRunOnCommand;
    public Runnable clientRunOnCommand;
    private TransportServer server;
    private Transport clientTransport;
    private Transport serverTransport;
    private int serverPort;
    private final AtomicInteger clientReceiveCount = new AtomicInteger(0);
    private final AtomicInteger clientErrorCount = new AtomicInteger(0);
    private final AtomicInteger serverReceiveCount = new AtomicInteger(0);
    private final AtomicInteger serverErrorCount = new AtomicInteger(0);
    private final AtomicBoolean ignoreClientError = new AtomicBoolean(false);
    private final AtomicBoolean ignoreServerError = new AtomicBoolean(false);

    protected void setUp() throws Exception {
        super.setUp();
        this.startTransportServer();
    }

    private void startClient() throws Exception, URISyntaxException {
        this.clientTransport = TransportFactory.connect((URI)new URI("tcp://localhost:" + this.serverPort + "?trace=true&wireFormat.maxInactivityDuration=1000"));
        this.clientTransport.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
                InactivityMonitorTest.this.clientReceiveCount.incrementAndGet();
                if (InactivityMonitorTest.this.clientRunOnCommand != null) {
                    InactivityMonitorTest.this.clientRunOnCommand.run();
                }
            }

            public void onException(IOException error) {
                if (!InactivityMonitorTest.this.ignoreClientError.get()) {
                    LOG.info("Client transport error:");
                    error.printStackTrace();
                    InactivityMonitorTest.this.clientErrorCount.incrementAndGet();
                }
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        this.clientTransport.start();
    }

    private void startTransportServer() throws IOException, URISyntaxException, Exception {
        this.server = TransportFactory.bind((URI)new URI("tcp://localhost:0?trace=true&wireFormat.maxInactivityDuration=1000"));
        this.server.setAcceptListener((TransportAcceptListener)this);
        this.server.start();
        this.serverPort = this.server.getSocketAddress().getPort();
    }

    protected void tearDown() throws Exception {
        this.ignoreClientError.set(true);
        this.ignoreServerError.set(true);
        try {
            if (this.clientTransport != null) {
                this.clientTransport.stop();
            }
            if (this.serverTransport != null) {
                this.serverTransport.stop();
            }
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.tearDown();
    }

    public void onAccept(Transport transport) {
        try {
            LOG.info("[" + this.getName() + "] Server Accepted a Connection");
            this.serverTransport = transport;
            this.serverTransport.setTransportListener(new TransportListener(){

                public void onCommand(Object command) {
                    InactivityMonitorTest.this.serverReceiveCount.incrementAndGet();
                    if (InactivityMonitorTest.this.serverRunOnCommand != null) {
                        InactivityMonitorTest.this.serverRunOnCommand.run();
                    }
                }

                public void onException(IOException error) {
                    if (!InactivityMonitorTest.this.ignoreClientError.get()) {
                        LOG.info("Server transport error:", (Throwable)error);
                        InactivityMonitorTest.this.serverErrorCount.incrementAndGet();
                    }
                }

                public void transportInterupted() {
                }

                public void transportResumed() {
                }
            });
            this.serverTransport.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onAcceptError(Exception error) {
        LOG.trace(error.toString());
    }

    public void testClientHang() throws Exception {
        this.clientTransport = new TcpTransport((WireFormat)new OpenWireFormat(), SocketFactory.getDefault(), new URI("tcp://localhost:" + this.serverPort), null);
        this.clientTransport.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
                InactivityMonitorTest.this.clientReceiveCount.incrementAndGet();
                if (InactivityMonitorTest.this.clientRunOnCommand != null) {
                    InactivityMonitorTest.this.clientRunOnCommand.run();
                }
            }

            public void onException(IOException error) {
                if (!InactivityMonitorTest.this.ignoreClientError.get()) {
                    LOG.info("Client transport error:");
                    error.printStackTrace();
                    InactivityMonitorTest.this.clientErrorCount.incrementAndGet();
                }
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        this.clientTransport.start();
        WireFormatInfo info = new WireFormatInfo();
        info.setVersion(6);
        info.setMaxInactivityDuration(1000L);
        this.clientTransport.oneway((Object)info);
        InactivityMonitorTest.assertEquals((int)0, (int)this.serverErrorCount.get());
        InactivityMonitorTest.assertEquals((int)0, (int)this.clientErrorCount.get());
        Thread.sleep(6000L);
        InactivityMonitorTest.assertEquals((int)0, (int)this.clientErrorCount.get());
        InactivityMonitorTest.assertTrue((this.serverErrorCount.get() > 0 ? 1 : 0) != 0);
    }

    public void testNoClientHang() throws Exception {
        this.startClient();
        InactivityMonitorTest.assertEquals((int)0, (int)this.serverErrorCount.get());
        InactivityMonitorTest.assertEquals((int)0, (int)this.clientErrorCount.get());
        Thread.sleep(4000L);
        InactivityMonitorTest.assertEquals((int)0, (int)this.clientErrorCount.get());
        InactivityMonitorTest.assertEquals((int)0, (int)this.serverErrorCount.get());
    }

    public void initCombosForTestNoClientHangWithServerBlock() throws Exception {
        this.startClient();
        this.addCombinationValues("clientInactivityLimit", new Object[]{1000L});
        this.addCombinationValues("serverInactivityLimit", new Object[]{1000L});
        this.addCombinationValues("serverRunOnCommand", new Object[]{new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Sleeping");
                    Thread.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }});
    }

    public void testNoClientHangWithServerBlock() throws Exception {
        this.startClient();
        InactivityMonitorTest.assertEquals((int)0, (int)this.serverErrorCount.get());
        InactivityMonitorTest.assertEquals((int)0, (int)this.clientErrorCount.get());
        Thread.sleep(4000L);
        InactivityMonitorTest.assertEquals((int)0, (int)this.clientErrorCount.get());
        InactivityMonitorTest.assertEquals((int)0, (int)this.serverErrorCount.get());
    }
}

