/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvisoryTopicCleanUpTest {
    private static final Logger LOG = LoggerFactory.getLogger(AdvisoryTopicCleanUpTest.class);
    private BrokerService broker;
    private String connectionUri;

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri + "?jms.redeliveryPolicy.maximumRedeliveries=2");
    }

    @Before
    public void setUp() throws Exception {
        this.createBroker();
    }

    @After
    public void tearDown() throws Exception {
        this.destroyBroker();
    }

    private void createBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setUseJmx(true);
        this.connectionUri = this.broker.addConnector("tcp://localhost:0").getPublishableConnectString();
        PolicyEntry policy = new PolicyEntry();
        policy.setAdvisoryForFastProducers(true);
        policy.setAdvisoryForConsumed(true);
        policy.setAdvisoryForDelivery(true);
        policy.setAdvisoryForDiscardingMessages(true);
        policy.setAdvisoryForSlowConsumers(true);
        policy.setAdvisoryWhenFull(true);
        policy.setProducerFlowControl(false);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.broker.setDestinationPolicy(pMap);
        this.broker.start();
    }

    protected Connection createConnection() throws Exception {
        Connection con = this.createConnectionFactory().createConnection();
        con.start();
        return con;
    }

    private void destroyBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    @Test
    public void testAdvisoryTopic() throws Exception {
        String name;
        ActiveMQDestination[] dests;
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        ActiveMQDestination queue = (ActiveMQDestination)session.createQueue("AdvisoryTopicCleanUpTestQueue");
        MessageProducer prod = session.createProducer((Destination)queue);
        Message message = session.createMessage();
        prod.send(message);
        message = session.createMessage();
        prod.send(message);
        message = session.createMessage();
        prod.send(message, 2, 4, 1000L);
        connection.close();
        connection = this.createConnection();
        session = connection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        message = consumer.receive(60000L);
        message.acknowledge();
        connection.close();
        connection = null;
        for (int i = 0; i < 2; ++i) {
            connection = this.createConnection();
            session = connection.createSession(true, 2);
            consumer = session.createConsumer((Destination)queue);
            message = consumer.receive(60000L);
            session.rollback();
            connection.close();
            connection = null;
        }
        Thread.sleep(2000L);
        connection = this.createConnection();
        session = connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        message = consumer.receive(1000L);
        if (message != null) {
            message.acknowledge();
        }
        connection.close();
        connection = null;
        TimeUnit.SECONDS.sleep(1L);
        for (ActiveMQDestination destination : dests = this.broker.getRegionBroker().getDestinations()) {
            name = destination.getPhysicalName();
            if (!name.contains(queue.getPhysicalName())) continue;
            LOG.info("Destination on Broker before removing the Queue: " + name);
        }
        dests = this.broker.getRegionBroker().getDestinations();
        if (dests == null) {
            Assert.fail((String)("Should have Destination for: " + queue.getPhysicalName()));
        }
        this.broker.getAdminView().removeQueue(queue.getPhysicalName());
        dests = this.broker.getRegionBroker().getDestinations();
        if (dests != null) {
            for (ActiveMQDestination destination : dests) {
                name = destination.getPhysicalName();
                LOG.info("Destination on broker after removing the Queue: " + name);
                Assert.assertFalse((String)("Advisory topic should not exist. " + name), (name.startsWith("ActiveMQ.Advisory") && name.contains(queue.getPhysicalName()) ? 1 : 0) != 0);
            }
        }
    }
}

