/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorAwareVTThatDropsMessagesWhenNoConsumer {
    protected static final Logger LOG = LoggerFactory.getLogger(SelectorAwareVTThatDropsMessagesWhenNoConsumer.class);
    private static final String QUEUE_NAME = "AMQ4899TestQueue";
    private static final String CONSUMER_QUEUE = "Consumer.Orders.VirtualOrders.AMQ4899TestQueue";
    private static final String PRODUCER_DESTINATION_NAME = "VirtualOrders.AMQ4899TestQueue";
    final AtomicInteger receivedCount = new AtomicInteger(0);
    private BrokerService broker;

    @Before
    public void setUp() {
        this.setupBroker("broker://()/localhost?");
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test(timeout=60000L)
    public void testVirtualTopicMultipleSelectors() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue consumerQueue = session.createQueue(CONSUMER_QUEUE);
        CountingListener listenerA = new CountingListener(this.receivedCount);
        MessageConsumer consumerA = session.createConsumer((Destination)consumerQueue);
        consumerA.setMessageListener((MessageListener)listenerA);
        Topic producerDestination = session.createTopic(PRODUCER_DESTINATION_NAME);
        MessageProducer producer = session.createProducer((Destination)producerDestination);
        TextMessage message = session.createTextMessage("bla");
        producer.send((Message)message);
        producer.send((Message)message);
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return SelectorAwareVTThatDropsMessagesWhenNoConsumer.this.receivedCount.get() == 2;
            }
        });
        consumerA.close();
        producer.send((Message)message);
        producer.send((Message)message);
        Assert.assertEquals((long)2L, (long)this.receivedCount.get());
        LOG.debug("Restarting consumerA");
        consumerA = session.createConsumer((Destination)consumerQueue);
        consumerA.setMessageListener((MessageListener)listenerA);
        producer.send((Message)message);
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return SelectorAwareVTThatDropsMessagesWhenNoConsumer.this.receivedCount.get() == 3;
            }
        });
        Assert.assertEquals((long)3L, (long)this.receivedCount.get());
        connection.close();
    }

    private void setupBroker(String uri) {
        try {
            this.broker = BrokerFactory.createBroker((String)uri);
            VirtualDestinationInterceptor interceptor = new VirtualDestinationInterceptor();
            VirtualTopic virtualTopic = new VirtualTopic();
            virtualTopic.setName("VirtualOrders.>");
            virtualTopic.setSelectorAware(true);
            VirtualDestination[] virtualDestinations = new VirtualDestination[]{virtualTopic};
            interceptor.setVirtualDestinations(virtualDestinations);
            this.broker.setDestinationInterceptors(new DestinationInterceptor[]{interceptor});
            this.broker.setUseJmx(false);
            this.broker.start();
            this.broker.waitUntilStarted();
        }
        catch (Exception e) {
            LOG.error("Failed creating broker", (Throwable)e);
        }
    }

    class CountingListener
    implements MessageListener {
        AtomicInteger counter;

        public CountingListener(AtomicInteger counter) {
            this.counter = counter;
        }

        public void onMessage(Message message) {
            this.counter.incrementAndGet();
        }
    }
}

