/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.util.MessageIdList;

public class SingleBrokerVirtualDestinationsWithWildcardTest
extends JmsMultipleBrokersTestSupport {
    public void testVirtualDestinations() throws Exception {
        this.startAllBrokers();
        this.sendReceive("local.test", true, "Consumer.a.local.test", false, 1, 1);
        this.sendReceive("global.test", true, "Consumer.a.global.test", false, 1, 1);
        this.destroyAllBrokers();
    }

    public void testVirtualDestinationsWithWildcardWithoutIndividualVirtualQueue() throws Exception {
        this.startAllBrokers();
        this.sendReceive("local.test.1", true, "Consumer.a.local.test.>", false, 1, 1);
        this.sendReceive("global.test.1", true, "Consumer.a.global.test.>", false, 1, 1);
        this.destroyAllBrokers();
    }

    public void testVirtualDestinationsWithWildcardWithIndividualVirtualQueue() throws Exception {
        this.startAllBrokers();
        this.sendReceive("local.test.1", true, "Consumer.a.local.test.1", false, 1, 1);
        this.sendReceive("local.test.1", true, "Consumer.a.local.test.>", false, 1, 1);
        this.sendReceive("local.test.1.2", true, "Consumer.a.local.test.>", false, 1, 1);
        this.sendReceive("global.test.1", true, "Consumer.a.global.test.1", false, 1, 1);
        this.sendReceive("global.test.1", true, "Consumer.a.global.test.>", false, 1, 1);
        this.sendReceive("global.test.1.2", true, "Consumer.a.global.test.>", false, 1, 1);
        this.destroyAllBrokers();
    }

    public void testVirtualDestinationsWithWildcardWithVirtualQueuePreCreated() throws Exception {
        this.startAllBrokers();
        this.sendReceive("Consumer.a.local.test.>", false, "Consumer.a.local.test.>", false, 1, 1);
        this.sendReceive("local.test.1", true, "Consumer.a.local.test.>", false, 1, 1);
        this.sendReceive("Consumer.a.global.test.>", false, "Consumer.a.global.test.>", false, 1, 1);
        this.sendReceive("global.test.1", true, "Consumer.a.global.test.>", false, 1, 1);
        this.destroyAllBrokers();
    }

    public void sendReceive(String dest1, boolean topic1, String dest2, boolean topic2, int send, int expected) throws Exception {
        MessageConsumer client = this.createConsumer("BrokerA", (Destination)this.createDestination(dest2, topic2));
        Thread.sleep(1000L);
        this.sendMessages("BrokerA", (Destination)this.createDestination(dest1, topic1), send);
        MessageIdList msgs = this.getConsumerMessages("BrokerA", client);
        msgs.setMaximumDuration(1000L);
        SingleBrokerVirtualDestinationsWithWildcardTest.assertEquals((int)expected, (int)msgs.getMessageCount());
        client.close();
        Thread.sleep(500L);
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        String options = new String("?useJmx=false&deleteAllMessagesOnStartup=true");
        this.createAndConfigureBroker(new URI("broker:(tcp://localhost:61616)/BrokerA" + options));
    }

    private BrokerService createAndConfigureBroker(URI uri) throws Exception {
        BrokerService broker = this.createBroker(uri);
        this.configurePersistenceAdapter(broker);
        VirtualDestinationInterceptor virtualDestinationInterceptor = new VirtualDestinationInterceptor();
        virtualDestinationInterceptor.setVirtualDestinations(new VirtualDestination[]{new VirtualTopic()});
        DestinationInterceptor[] destinationInterceptors = new DestinationInterceptor[]{virtualDestinationInterceptor};
        broker.setDestinationInterceptors(destinationInterceptors);
        return broker;
    }

    protected void configurePersistenceAdapter(BrokerService broker) throws IOException {
        File dataFileDir = new File("target/test-amq-data/kahadb/" + broker.getBrokerName());
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(dataFileDir);
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
    }
}

