/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.MessageIdList;

public class TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest
extends JmsMultipleBrokersTestSupport {
    protected static final int MESSAGE_COUNT = 100;

    public void testRemoteBrokerHasConsumer() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        msgsA.waitForMessagesToArrive(100);
        msgsB.waitForMessagesToArrive(100);
        TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest.assertEquals((int)100, (int)msgsA.getMessageCount());
        TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest.assertEquals((int)100, (int)msgsB.getMessageCount());
    }

    public void testRemoteBrokerHasNoConsumer() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        msgsA.waitForMessagesToArrive(100);
        TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest.assertEquals((int)100, (int)msgsA.getMessageCount());
    }

    public void testDuplexStaticRemoteBrokerHasNoConsumer() throws Exception {
        boolean dynamicOnly = true;
        int networkTTL = 2;
        boolean conduit = true;
        this.bridgeBrokers("BrokerA", "BrokerB", dynamicOnly, networkTTL, conduit);
        this.bridgeBrokers("BrokerB", "BrokerA", dynamicOnly, networkTTL, conduit);
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        Thread.sleep(2000L);
        int messageCount = 2000;
        this.sendMessages("BrokerA", (Destination)dest, messageCount);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        msgsA.waitForMessagesToArrive(messageCount);
        TwoBrokerMessageNotSentToRemoteWhenNoConsumerTest.assertEquals((int)messageCount, (int)msgsA.getMessageCount());
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB?persistent=false&useJmx=false"));
    }
}

