/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.region.policy.RedeliveryPolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;

public class RedeliveryPolicyTest
extends JmsTestSupport {
    public static Test suite() {
        return RedeliveryPolicyTest.suite(RedeliveryPolicyTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RedeliveryPolicyTest.suite());
    }

    public void testExponentialRedeliveryPolicyDelaysDeliveryOnRollback() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue(this.getName());
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(500L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
    }

    public void testNornalRedeliveryPolicyDelaysDeliveryOnRollback() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue(this.getName());
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
    }

    public void testDLQHandling() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(2);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        MessageConsumer dlqConsumer = session.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
        m = (TextMessage)dlqConsumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.commit();
    }

    public void testInfiniteMaximumNumberOfRedeliveries() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(-1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.commit();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }

    public void testMaximumRedeliveryDelay() throws Exception {
        TextMessage m;
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(10L);
        policy.setUseExponentialBackOff(true);
        policy.setMaximumRedeliveries(-1);
        policy.setRedeliveryDelay(50L);
        policy.setMaximumRedeliveryDelay(1000L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        for (int i = 0; i < 10; ++i) {
            m = (TextMessage)consumer.receive(2000L);
            RedeliveryPolicyTest.assertNotNull((Object)m);
            RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
            session.rollback();
        }
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.commit();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
        RedeliveryPolicyTest.assertTrue((policy.getNextRedeliveryDelay(Long.MAX_VALUE) == 1000L ? 1 : 0) != 0);
    }

    public void testZeroMaximumNumberOfRedeliveries() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(0);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }

    public void testInitialRedeliveryDelayZero() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
        session.commit();
    }

    public void testInitialRedeliveryDelayOne() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(1000L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }

    public void testRedeliveryDelayOne() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(1000L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(2);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((String)"first immediate redelivery", (Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((String)("second delivery delayed: " + m), (Object)m);
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }

    public void testRedeliveryPolicyPerDestination() throws Exception {
        RedeliveryPolicy queuePolicy = new RedeliveryPolicy();
        queuePolicy.setInitialRedeliveryDelay(0L);
        queuePolicy.setRedeliveryDelay(1000L);
        queuePolicy.setUseExponentialBackOff(false);
        queuePolicy.setMaximumRedeliveries(2);
        RedeliveryPolicy topicPolicy = new RedeliveryPolicy();
        topicPolicy.setInitialRedeliveryDelay(0L);
        topicPolicy.setRedeliveryDelay(1000L);
        topicPolicy.setUseExponentialBackOff(false);
        topicPolicy.setMaximumRedeliveries(3);
        RedeliveryPolicyMap map = this.connection.getRedeliveryPolicyMap();
        map.put((ActiveMQDestination)new ActiveMQTopic(">"), (Object)topicPolicy);
        map.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)queuePolicy);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue queue = new ActiveMQQueue("TEST");
        ActiveMQTopic topic = new ActiveMQTopic("TEST");
        MessageProducer producer = session.createProducer(null);
        MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
        MessageConsumer topicConsumer = session.createConsumer((Destination)topic);
        producer.send((Destination)queue, (Message)session.createTextMessage("1st"));
        producer.send((Destination)queue, (Message)session.createTextMessage("2nd"));
        producer.send((Destination)topic, (Message)session.createTextMessage("1st"));
        producer.send((Destination)topic, (Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((String)"first immediate redelivery", (Object)m);
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((String)"first immediate redelivery", (Object)m);
        session.rollback();
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNull((String)("second delivery delayed: " + m), (Object)m);
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNull((String)("second delivery delayed: " + m), (Object)m);
        m = (TextMessage)queueConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)topicConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }
}

