/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.advisory;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.DestinationInfo;

public class AdvisoryJmxTest
extends EmbeddedBrokerTestSupport {
    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(this.isPersistent());
        answer.addConnector(this.bindAddress);
        ManagementContext context = new ManagementContext();
        context.setConnectorPort(1199);
        answer.setManagementContext(context);
        return answer;
    }

    public void testCreateDeleteDestinations() throws Exception {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1199/jmxrmi");
        JMXConnector connector = JMXConnectorFactory.connect(url, null);
        connector.connect();
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        ObjectName name = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost");
        BrokerViewMBean brokerMbean = MBeanServerInvocationHandler.newProxyInstance(connection, name, BrokerViewMBean.class, true);
        Connection conn = this.createConnection();
        Session sess = conn.createSession(false, 1);
        MessageConsumer consumer = sess.createConsumer((Destination)sess.createTopic("ActiveMQ.Advisory.Queue"));
        conn.start();
        Queue dest = sess.createQueue("test");
        brokerMbean.addQueue("test");
        ActiveMQMessage msg = (ActiveMQMessage)consumer.receive(1000L);
        AdvisoryJmxTest.assertNotNull((Object)msg);
        AdvisoryJmxTest.assertTrue((boolean)(msg.getDataStructure() instanceof DestinationInfo));
        AdvisoryJmxTest.assertEquals((Object)((DestinationInfo)msg.getDataStructure()).getDestination(), (Object)dest);
        AdvisoryJmxTest.assertEquals((int)((DestinationInfo)msg.getDataStructure()).getOperationType(), (int)0);
        brokerMbean.removeQueue("test");
        msg = (ActiveMQMessage)consumer.receive(1000L);
        AdvisoryJmxTest.assertNotNull((Object)msg);
        AdvisoryJmxTest.assertTrue((boolean)(msg.getDataStructure() instanceof DestinationInfo));
        AdvisoryJmxTest.assertEquals((Object)((DestinationInfo)msg.getDataStructure()).getDestination(), (Object)dest);
        AdvisoryJmxTest.assertEquals((int)((DestinationInfo)msg.getDataStructure()).getOperationType(), (int)1);
        brokerMbean.addQueue("test");
        msg = (ActiveMQMessage)consumer.receive(1000L);
        AdvisoryJmxTest.assertNotNull((Object)msg);
        AdvisoryJmxTest.assertTrue((boolean)(msg.getDataStructure() instanceof DestinationInfo));
        AdvisoryJmxTest.assertEquals((Object)((DestinationInfo)msg.getDataStructure()).getDestination(), (Object)dest);
        AdvisoryJmxTest.assertEquals((int)((DestinationInfo)msg.getDataStructure()).getOperationType(), (int)0);
        AdvisoryJmxTest.assertEquals((int)((DestinationInfo)msg.getDataStructure()).getOperationType(), (int)0);
    }
}

