/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.broker.ft.DbRestartJDBCQueueMasterSlaveTest;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.LeaseDatabaseLocker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbRestartJDBCQueueMasterSlaveLeaseTest
extends DbRestartJDBCQueueMasterSlaveTest {
    private static final transient Logger LOG = LoggerFactory.getLogger(DbRestartJDBCQueueMasterSlaveLeaseTest.class);

    @Override
    protected void configureJdbcPersistenceAdapter(JDBCPersistenceAdapter persistenceAdapter) throws IOException {
        super.configureJdbcPersistenceAdapter(persistenceAdapter);
        persistenceAdapter.setLocker((Locker)new LeaseDatabaseLocker());
        persistenceAdapter.getLocker().setLockAcquireSleepInterval(this.getLockAcquireSleepInterval());
        persistenceAdapter.setLockKeepAlivePeriod(this.getLockKeepAlivePeriod());
    }

    private long getLockKeepAlivePeriod() {
        return 500L;
    }

    private long getLockAcquireSleepInterval() {
        return 2000L;
    }

    @Override
    protected void delayTillRestartRequired() {
        LOG.info("delay for less than lease quantum. While Db is offline, master should stay alive");
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void verifyExpectedBroker(int inflightMessageCount) {
        if (inflightMessageCount == 0 || inflightMessageCount == this.failureCount + 10) {
            DbRestartJDBCQueueMasterSlaveLeaseTest.assertEquals((String)"connected to master", (String)this.master.getBrokerName(), (String)((ActiveMQConnection)this.sendConnection).getBrokerName());
        }
    }
}

