/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TransactionRolledBackException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ft.JDBCQueueMasterSlaveTest;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbRestartJDBCQueueMasterSlaveTest
extends JDBCQueueMasterSlaveTest {
    private static final transient Logger LOG = LoggerFactory.getLogger(DbRestartJDBCQueueMasterSlaveTest.class);

    @Override
    protected void messageSent() throws Exception {
        this.verifyExpectedBroker(this.inflightMessageCount);
        if (++this.inflightMessageCount == this.failureCount) {
            LOG.info("STOPPING DB!@!!!!");
            final EmbeddedDataSource ds = ((JDBCQueueMasterSlaveTest.SyncDataSource)this.getExistingDataSource()).getDelegate();
            ds.setShutdownDatabase("shutdown");
            LOG.info("DB STOPPED!@!!!!");
            Thread dbRestartThread = new Thread("db-re-start-thread"){

                @Override
                public void run() {
                    DbRestartJDBCQueueMasterSlaveTest.this.delayTillRestartRequired();
                    ds.setShutdownDatabase("false");
                    LOG.info("DB RESTARTED!@!!!!");
                }
            };
            dbRestartThread.start();
        }
        this.verifyExpectedBroker(this.inflightMessageCount);
    }

    protected void verifyExpectedBroker(int inflightMessageCount) {
        if (inflightMessageCount == 0) {
            DbRestartJDBCQueueMasterSlaveTest.assertEquals((String)"connected to master", (String)this.master.getBrokerName(), (String)((ActiveMQConnection)this.sendConnection).getBrokerName());
        } else if (inflightMessageCount == this.failureCount + 10) {
            DbRestartJDBCQueueMasterSlaveTest.assertEquals((String)"connected to slave", (String)((BrokerService)this.slave.get()).getBrokerName(), (String)((ActiveMQConnection)this.sendConnection).getBrokerName());
        }
    }

    protected void delayTillRestartRequired() {
        LOG.info("Waiting for master broker to Stop");
        this.master.waitUntilStopped();
    }

    @Override
    protected void sendToProducer(MessageProducer producer, Destination producerDestination, Message message) throws JMSException {
        boolean sent = false;
        do {
            try {
                producer.send(producerDestination, message);
                sent = true;
            }
            catch (JMSException e) {
                LOG.info("Exception on producer send for: " + message, (Throwable)e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
        } while (!sent);
    }

    @Override
    protected Session createReceiveSession(Connection receiveConnection) throws Exception {
        return receiveConnection.createSession(true, 0);
    }

    @Override
    protected void consumeMessage(Message message, List<Message> messageList) {
        try {
            this.receiveSession.commit();
            super.consumeMessage(message, messageList);
        }
        catch (JMSException e) {
            TransactionRolledBackException transactionRolledBackException;
            LOG.info("Failed to commit message receipt: " + message, (Throwable)e);
            try {
                this.receiveSession.rollback();
            }
            catch (JMSException ignored) {
                // empty catch block
            }
            if (!(e.getCause() instanceof TransactionRolledBackException) || (transactionRolledBackException = (TransactionRolledBackException)e.getCause()).getMessage().indexOf("in doubt") != -1) {
                // empty if block
            }
        }
    }
}

