/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.ft.QueueMasterSlaveTestSupport;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.DataSourceServiceSupport;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.IOHelper;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class JDBCQueueMasterSlaveTest
extends QueueMasterSlaveTestSupport {
    protected DataSource sharedDs;
    protected String MASTER_URL = "tcp://localhost:62001";
    protected String SLAVE_URL = "tcp://localhost:62002";

    @Override
    protected void setUp() throws Exception {
        this.sharedDs = new SyncDataSource((EmbeddedDataSource)DataSourceServiceSupport.createDataSource((String)IOHelper.getDefaultDataDirectory()));
        super.setUp();
    }

    @Override
    protected void createMaster() throws Exception {
        this.master = new BrokerService();
        this.master.setBrokerName("master");
        this.master.addConnector(this.MASTER_URL);
        this.master.setUseJmx(false);
        this.master.setPersistent(true);
        this.master.setDeleteAllMessagesOnStartup(true);
        JDBCPersistenceAdapter persistenceAdapter = new JDBCPersistenceAdapter();
        persistenceAdapter.setDataSource(this.getExistingDataSource());
        this.configureJdbcPersistenceAdapter(persistenceAdapter);
        this.master.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.configureBroker(this.master);
        this.master.start();
    }

    protected void configureBroker(BrokerService master) {
    }

    @Override
    protected void createSlave() throws Exception {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    BrokerService broker = new BrokerService();
                    broker.setBrokerName("slave");
                    TransportConnector connector = new TransportConnector();
                    connector.setUri(new URI(JDBCQueueMasterSlaveTest.this.SLAVE_URL));
                    broker.addConnector(connector);
                    broker.setUseJmx(false);
                    broker.setPersistent(true);
                    JDBCPersistenceAdapter persistenceAdapter = new JDBCPersistenceAdapter();
                    persistenceAdapter.setDataSource(JDBCQueueMasterSlaveTest.this.getExistingDataSource());
                    persistenceAdapter.setCreateTablesOnStartup(false);
                    broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
                    JDBCQueueMasterSlaveTest.this.configureJdbcPersistenceAdapter(persistenceAdapter);
                    JDBCQueueMasterSlaveTest.this.configureBroker(broker);
                    broker.start();
                    JDBCQueueMasterSlaveTest.this.slave.set(broker);
                    JDBCQueueMasterSlaveTest.this.slaveStarted.countDown();
                }
                catch (IllegalStateException expectedOnShutdown) {
                }
                catch (Exception e) {
                    TestCase.fail((String)("failed to start slave broker, reason:" + e));
                }
            }
        };
        t.start();
    }

    protected void configureJdbcPersistenceAdapter(JDBCPersistenceAdapter persistenceAdapter) throws IOException {
        persistenceAdapter.setLockKeepAlivePeriod(500L);
        persistenceAdapter.getLocker().setLockAcquireSleepInterval(500L);
    }

    protected DataSource getExistingDataSource() throws Exception {
        return this.sharedDs;
    }

    class SyncDataSource
    implements DataSource {
        final EmbeddedDataSource delegate;

        SyncDataSource(EmbeddedDataSource dataSource) {
            this.delegate = dataSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection getConnection() throws SQLException {
            SyncDataSource syncDataSource = this;
            synchronized (syncDataSource) {
                return this.delegate.getConnection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            SyncDataSource syncDataSource = this;
            synchronized (syncDataSource) {
                return this.delegate.getConnection();
            }
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        EmbeddedDataSource getDelegate() {
            return this.delegate;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }
    }
}

