/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.cursors.FilePendingMessageCursor;
import org.apache.activemq.store.PList;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.ByteSequence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePendingMessageCursorTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(FilePendingMessageCursorTestSupport.class);
    protected BrokerService brokerService;
    protected FilePendingMessageCursor underTest;

    @After
    public void stopBroker() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.getTempDataStore().stop();
        }
    }

    private void createBrokerWithTempStoreLimit() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setUseJmx(false);
        SystemUsage usage = this.brokerService.getSystemUsage();
        usage.getTempUsage().setLimit(15744000L);
        PList dud = this.brokerService.getTempDataStore().getPList("dud");
        dud.addFirst("A", new ByteSequence("A".getBytes()));
    }

    @Test
    public void testAddToEmptyCursorWhenTempStoreIsFull() throws Exception {
        this.createBrokerWithTempStoreLimit();
        SystemUsage usage = this.brokerService.getSystemUsage();
        Assert.assertTrue((String)("temp store is full: %" + usage.getTempUsage().getPercentUsage()), (boolean)usage.getTempUsage().isFull());
        this.underTest = new FilePendingMessageCursor(this.brokerService.getBroker(), "test", false);
        this.underTest.setSystemUsage(usage);
        this.underTest.addMessageLast((MessageReference)QueueMessageReference.NULL_MESSAGE);
        Assert.assertFalse((String)"cursor is not full", (boolean)this.underTest.isFull());
    }

    @Test
    public void testResetClearsIterator() throws Exception {
        this.createBrokerWithTempStoreLimit();
        this.underTest = new FilePendingMessageCursor(this.brokerService.getBroker(), "test", false);
        this.underTest.addMessageLast((MessageReference)QueueMessageReference.NULL_MESSAGE);
        this.underTest.reset();
        this.underTest.release();
        try {
            this.underTest.hasNext();
            Assert.fail((String)"expect npe on use of iterator after release");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

