/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.broker.scheduler.SchedulerBroker;
import org.apache.activemq.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsCronSchedulerTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JmsCronSchedulerTest.class);

    public void testSimulatenousCron() throws Exception {
        int COUNT = 10;
        final AtomicInteger count = new AtomicInteger();
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        final CountDownLatch latch = new CountDownLatch(10);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
                count.incrementAndGet();
                LOG.debug("Received one Message, count is at: " + count.get());
            }
        });
        connection.start();
        for (int i = 0; i < 10; ++i) {
            MessageProducer producer = session.createProducer((Destination)this.destination);
            TextMessage message = session.createTextMessage("test msg " + i);
            message.setStringProperty("AMQ_SCHEDULED_CRON", "* * * * *");
            producer.send((Message)message);
            producer.close();
            Thread.sleep(2000L);
        }
        SchedulerBroker sb = (SchedulerBroker)this.broker.getBroker().getAdaptor(SchedulerBroker.class);
        JobScheduler js = sb.getJobScheduler();
        List list = js.getAllJobs();
        JmsCronSchedulerTest.assertEquals((int)10, (int)list.size());
        latch.await(2L, TimeUnit.MINUTES);
        JmsCronSchedulerTest.assertEquals((int)10, (int)count.get());
    }

    public void testCronScheduleWithTtlSet() throws Exception {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        producer.setTimeToLive(TimeUnit.MINUTES.toMillis(1L));
        TextMessage message = session.createTextMessage("test msg ");
        message.setStringProperty("AMQ_SCHEDULED_CRON", "* * * * *");
        producer.send((Message)message);
        producer.close();
        Thread.sleep(TimeUnit.MINUTES.toMillis(2L));
        JmsCronSchedulerTest.assertNotNull((Object)consumer.receiveNoWait());
        JmsCronSchedulerTest.assertNull((Object)consumer.receiveNoWait());
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "vm://localhost";
        super.setUp();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        return this.createBroker(true);
    }

    protected BrokerService createBroker(boolean delete) throws Exception {
        File schedulerDirectory = new File("target/scheduler");
        if (delete) {
            IOHelper.mkdirs((File)schedulerDirectory);
            IOHelper.deleteChildren((File)schedulerDirectory);
        }
        BrokerService answer = new BrokerService();
        answer.setPersistent(this.isPersistent());
        answer.getManagementContext().setCreateConnector(false);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setDataDirectory("target");
        answer.setSchedulerDirectoryFile(schedulerDirectory);
        answer.setSchedulerSupport(true);
        answer.setUseJmx(false);
        answer.addConnector(this.bindAddress);
        return answer;
    }
}

