/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.kahadb.KahaDBStore;

public class AMQ2356Test
extends TestCase {
    protected static final int MESSAGE_COUNT = 1000;
    protected static final int NUMBER_OF_PAIRS = 10;
    protected BrokerService broker;
    protected String brokerURL = "tcp://localhost:61616";
    protected int destinationCount;

    public void testScenario() throws Exception {
        for (int i = 0; i < 10; ++i) {
            ActiveMQQueue queue = new ActiveMQQueue(((Object)((Object)this)).getClass().getName() + ":" + i);
            ProducerConsumerPair cp = new ProducerConsumerPair();
            cp.start(this.brokerURL, (Destination)queue, 1000);
            cp.testRun();
            cp.stop();
        }
    }

    protected Destination getDestination(Session session) throws JMSException {
        String destinationName = ((Object)((Object)this)).getClass().getName() + "." + this.destinationCount++;
        return session.createQueue(destinationName);
    }

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer);
        answer.start();
        return answer;
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        File dataFileDir = new File("target/test-amq-data/bugs/AMQ2356/kahadb");
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(dataFileDir);
        answer.setUseJmx(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setOptimizedDispatch(true);
        policyMap.setDefaultEntry(policy);
        answer.setDestinationPolicy(policyMap);
        answer.setAdvisorySupport(false);
        answer.setEnableStatistics(false);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.addConnector(this.brokerURL);
    }

    static class ProducerConsumerPair {
        private Destination destination;
        private MessageProducer producer;
        private MessageConsumer consumer;
        private Connection producerConnection;
        private Connection consumerConnection;
        private int numberOfMessages;

        ProducerConsumerPair() {
        }

        void start(String brokerURL, Destination dest, int msgNum) throws Exception {
            this.destination = dest;
            this.numberOfMessages = msgNum;
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(brokerURL);
            this.producerConnection = cf.createConnection();
            this.producerConnection.start();
            this.consumerConnection = cf.createConnection();
            this.consumerConnection.start();
            this.producer = this.createProducer(this.producerConnection);
            this.consumer = this.createConsumer(this.consumerConnection);
        }

        void testRun() throws Exception {
            Session s = this.producerConnection.createSession(false, 1);
            for (int i = 0; i < this.numberOfMessages; ++i) {
                BytesMessage msg = s.createBytesMessage();
                msg.writeBytes(new byte[1024]);
                this.producer.send((Message)msg);
            }
            int received = 0;
            for (int i = 0; i < this.numberOfMessages; ++i) {
                Message msg = this.consumer.receive();
                TestCase.assertNotNull((Object)msg);
                ++received;
            }
            TestCase.assertEquals((String)("Messages received on " + this.destination), (int)this.numberOfMessages, (int)received);
        }

        void stop() throws Exception {
            if (this.producerConnection != null) {
                this.producerConnection.close();
            }
            if (this.consumerConnection != null) {
                this.consumerConnection.close();
            }
        }

        private MessageProducer createProducer(Connection connection) throws Exception {
            Session session = connection.createSession(false, 1);
            MessageProducer result = session.createProducer(this.destination);
            return result;
        }

        private MessageConsumer createConsumer(Connection connection) throws Exception {
            Session session = connection.createSession(false, 1);
            MessageConsumer result = session.createConsumer(this.destination);
            return result;
        }
    }
}

