/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.MalformedURLException;
import java.util.Set;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkConnector;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplexNetworkMBeanTest {
    protected static final Logger LOG = LoggerFactory.getLogger(DuplexNetworkMBeanTest.class);
    protected final int numRestarts = 3;

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("broker");
        broker.addConnector("tcp://localhost:61617?transport.reuseAddress=true");
        return broker;
    }

    protected BrokerService createNetworkedBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("networkedBroker");
        broker.addConnector("tcp://localhost:62617?transport.reuseAddress=true");
        NetworkConnector networkConnector = broker.addNetworkConnector("static:(tcp://localhost:61617?wireFormat.maxInactivityDuration=500)?useExponentialBackOff=false");
        networkConnector.setDuplex(true);
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMbeanPresenceOnNetworkBrokerRestart() throws Exception {
        BrokerService broker = this.createBroker();
        try {
            broker.start();
            Assert.assertEquals((long)1L, (long)this.countMbeans(broker, "connector", 30000));
            Assert.assertEquals((long)0L, (long)this.countMbeans(broker, "connectionName"));
            BrokerService networkedBroker = null;
            for (int i = 0; i < 3; ++i) {
                networkedBroker = this.createNetworkedBroker();
                try {
                    networkedBroker.start();
                    Assert.assertEquals((long)1L, (long)this.countMbeans(networkedBroker, "networkBridge", 2000));
                    Assert.assertEquals((long)1L, (long)this.countMbeans(broker, "networkBridge", 2000));
                    Assert.assertEquals((long)1L, (long)this.countMbeans(broker, "connectionName"));
                }
                finally {
                    networkedBroker.stop();
                    networkedBroker.waitUntilStopped();
                }
                Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "stopped"));
                Assert.assertEquals((long)0L, (long)this.countMbeans(broker, "networkBridge"));
            }
            Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "networkBridge"));
            Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "connector"));
            Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "connectionName"));
            Assert.assertEquals((long)1L, (long)this.countMbeans(broker, "connector"));
        }
        finally {
            broker.stop();
            broker.waitUntilStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMbeanPresenceOnBrokerRestart() throws Exception {
        BrokerService networkedBroker = this.createNetworkedBroker();
        try {
            networkedBroker.start();
            Assert.assertEquals((long)1L, (long)this.countMbeans(networkedBroker, "connector=networkConnectors", 30000));
            Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "connectionName"));
            BrokerService broker = null;
            for (int i = 0; i < 3; ++i) {
                broker = this.createBroker();
                try {
                    broker.start();
                    Assert.assertEquals((long)1L, (long)this.countMbeans(networkedBroker, "networkBridge", 5000));
                    Assert.assertEquals((String)("restart number: " + i), (long)1L, (long)this.countMbeans(broker, "connectionName", 10000));
                }
                finally {
                    broker.stop();
                    broker.waitUntilStopped();
                }
                Assert.assertEquals((long)0L, (long)this.countMbeans(broker, "stopped"));
            }
            Assert.assertEquals((long)1L, (long)this.countMbeans(networkedBroker, "connector=networkConnectors"));
            Assert.assertEquals((long)0L, (long)this.countMbeans(networkedBroker, "connectionName"));
            Assert.assertEquals((long)0L, (long)this.countMbeans(broker, "connectionName"));
        }
        finally {
            networkedBroker.stop();
            networkedBroker.waitUntilStopped();
        }
    }

    private int countMbeans(BrokerService broker, String type) throws Exception {
        return this.countMbeans(broker, type, 0);
    }

    private int countMbeans(BrokerService broker, String type, int timeout) throws Exception {
        long expiryTime = System.currentTimeMillis() + (long)timeout;
        if (!type.contains("=")) {
            type = type + "=*";
        }
        ObjectName beanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=" + broker.getBrokerName() + "," + type + ",*");
        Set mbeans = null;
        int count = 0;
        do {
            if (timeout > 0) {
                Thread.sleep(100L);
            }
            LOG.info("Query name: " + beanName);
            mbeans = broker.getManagementContext().queryNames(beanName, null);
            if (mbeans != null) {
                count = mbeans.size();
                continue;
            }
            this.logAllMbeans(broker);
        } while ((mbeans == null || mbeans.isEmpty()) && expiryTime > System.currentTimeMillis());
        if (timeout > 0) {
            Assume.assumeNotNull((Object[])new Object[]{mbeans});
        }
        return count;
    }

    private void logAllMbeans(BrokerService broker) throws MalformedURLException {
        try {
            Set all = broker.getManagementContext().queryNames(null, null);
            LOG.info("Total MBean count=" + all.size());
            for (Object o : all) {
                ObjectInstance bean = (ObjectInstance)o;
                LOG.info(bean.getObjectName().toString());
            }
        }
        catch (Exception ignored) {
            LOG.warn("getMBeanServer ex: " + ignored);
        }
    }
}

