/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionChurnTest
extends TestCase {
    protected static final int CONNECTION_COUNT = 200;
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionChurnTest.class);
    protected BrokerService broker;
    protected String bindAddress = "tcp://localhost:61616?transport.closeAsync=false";
    protected int topicCount;

    public void testPerformance() throws Exception {
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        ArrayList<Connection> list = new ArrayList<Connection>();
        for (int i = 0; i < 200; ++i) {
            Connection connection = factory.createConnection();
            connection.start();
            list.add(connection);
            LOG.info("Created " + i);
            if (i % 100 != 0) continue;
            this.closeConnections(list);
        }
        this.closeConnections(list);
    }

    protected void closeConnections(List<Connection> list) throws JMSException {
        for (Connection c : list) {
            c.close();
        }
        for (TransportConnector tc : this.broker.getTransportConnectors()) {
            System.out.println(tc.getConnections().size());
        }
        list.clear();
    }

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover://tcp://localhost:61616");
        return cf;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer);
        answer.start();
        return answer;
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        answer.setPersistent(false);
        answer.addConnector(this.bindAddress);
        answer.setDeleteAllMessagesOnStartup(true);
    }
}

