/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.LeaseDatabaseLocker;
import org.apache.activemq.store.jdbc.adapter.DefaultJDBCAdapter;
import org.apache.activemq.util.Wait;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseDatabaseLockerTest {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseDatabaseLockerTest.class);
    JDBCPersistenceAdapter jdbc;
    BrokerService brokerService;
    EmbeddedDataSource dataSource;

    @Before
    public void setUpStore() throws Exception {
        this.dataSource = new EmbeddedDataSource();
        this.dataSource.setDatabaseName("derbyDb");
        this.dataSource.setCreateDatabase("create");
        this.jdbc = new JDBCPersistenceAdapter();
        this.jdbc.setDataSource((DataSource)this.dataSource);
        this.brokerService = new BrokerService();
        this.jdbc.setBrokerService(this.brokerService);
        this.jdbc.getAdapter().doCreateTables(this.jdbc.getTransactionContext());
    }

    @Test
    public void testLockInterleave() throws Exception {
        LeaseDatabaseLocker lockerA = new LeaseDatabaseLocker();
        lockerA.setLeaseHolderId("First");
        lockerA.configure((PersistenceAdapter)this.jdbc);
        final LeaseDatabaseLocker lockerB = new LeaseDatabaseLocker();
        lockerB.setLeaseHolderId("Second");
        lockerB.configure((PersistenceAdapter)this.jdbc);
        final AtomicBoolean blocked = new AtomicBoolean(true);
        final Connection connection = this.dataSource.getConnection();
        this.printLockTable(connection);
        lockerA.start();
        this.printLockTable(connection);
        Assert.assertTrue((String)"First has lock", (boolean)lockerA.keepAlive());
        final CountDownLatch lockerBStarting = new CountDownLatch(1);
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    lockerBStarting.countDown();
                    lockerB.start();
                    blocked.set(false);
                    LeaseDatabaseLockerTest.this.printLockTable(connection);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return lockerBStarting.await(1L, TimeUnit.SECONDS);
            }
        });
        TimeUnit.MILLISECONDS.sleep(lockerB.getLockAcquireSleepInterval());
        Assert.assertTrue((String)"B is blocked", (boolean)blocked.get());
        Assert.assertTrue((String)"A is good", (boolean)lockerA.keepAlive());
        this.printLockTable(connection);
        lockerA.stop();
        this.printLockTable(connection);
        TimeUnit.MILLISECONDS.sleep(2L * lockerB.getLockAcquireSleepInterval());
        Assert.assertFalse((String)"lockerB has the lock", (boolean)blocked.get());
        lockerB.stop();
        this.printLockTable(connection);
    }

    @Test
    public void testLockAcquireRace() throws Exception {
        String fakeId = "Anon";
        final Connection connection = this.dataSource.getConnection();
        PreparedStatement statement = connection.prepareStatement(this.jdbc.getStatements().getLeaseObtainStatement());
        long now = System.currentTimeMillis();
        statement.setString(1, "Anon");
        statement.setLong(2, now + 30000L);
        statement.setLong(3, now);
        Assert.assertEquals((String)"we got the lease", (long)1L, (long)statement.executeUpdate());
        this.printLockTable(connection);
        final LeaseDatabaseLocker lockerA = new LeaseDatabaseLocker();
        lockerA.setLeaseHolderId("A");
        lockerA.configure((PersistenceAdapter)this.jdbc);
        final LeaseDatabaseLocker lockerB = new LeaseDatabaseLocker();
        lockerB.setLeaseHolderId("B");
        lockerB.configure((PersistenceAdapter)this.jdbc);
        final HashSet lockedSet = new HashSet();
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    lockerA.start();
                    lockedSet.add(lockerA);
                    LeaseDatabaseLockerTest.this.printLockTable(connection);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    lockerB.start();
                    lockedSet.add(lockerB);
                    LeaseDatabaseLockerTest.this.printLockTable(connection);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        TimeUnit.SECONDS.sleep(2L);
        Assert.assertTrue((String)"no start", (boolean)lockedSet.isEmpty());
        Assert.assertFalse((String)"A is blocked", (boolean)lockerA.keepAlive());
        Assert.assertFalse((String)"B is blocked", (boolean)lockerB.keepAlive());
        LOG.info("releasing phony lock Anon");
        statement = connection.prepareStatement(this.jdbc.getStatements().getLeaseUpdateStatement());
        statement.setString(1, null);
        statement.setLong(2, 0L);
        statement.setString(3, "Anon");
        Assert.assertEquals((String)"we released Anon", (long)1L, (long)statement.executeUpdate());
        LOG.info("released Anon");
        this.printLockTable(connection);
        TimeUnit.MILLISECONDS.sleep(10000L);
        Assert.assertEquals((String)"one locker started", (long)1L, (long)lockedSet.size());
        Assert.assertTrue((String)"one isAlive", (lockerA.keepAlive() || lockerB.keepAlive() ? 1 : 0) != 0);
        LeaseDatabaseLocker winner = (LeaseDatabaseLocker)lockedSet.iterator().next();
        winner.stop();
        lockedSet.remove(winner);
        TimeUnit.MILLISECONDS.sleep(10000L);
        Assert.assertEquals((String)"one locker started", (long)1L, (long)lockedSet.size());
        ((LeaseDatabaseLocker)lockedSet.iterator().next()).stop();
        this.printLockTable(connection);
    }

    private void printLockTable(Connection connection) throws Exception {
        DefaultJDBCAdapter.printQuery((Connection)connection, (String)"SELECT * from ACTIVEMQ_LOCK", (PrintStream)System.err);
    }
}

