/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.util.HashMap;
import org.apache.activemq.transport.failover.FailoverClusterTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverPriorityTest
extends FailoverClusterTestSupport {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String BROKER_A_CLIENT_TC_ADDRESS = "tcp://127.0.0.1:61616";
    private static final String BROKER_B_CLIENT_TC_ADDRESS = "tcp://127.0.0.1:61617";
    private HashMap<String, String> urls = new HashMap();
    private static final String BROKER_A_NAME = "BROKERA";
    private static final String BROKER_B_NAME = "BROKERB";

    public void setUp() throws Exception {
        super.setUp();
        this.urls.put(BROKER_A_NAME, BROKER_A_CLIENT_TC_ADDRESS);
        this.urls.put(BROKER_B_NAME, BROKER_B_CLIENT_TC_ADDRESS);
    }

    public void testPriorityBackup() throws Exception {
        this.createBrokerA();
        this.createBrokerB();
        this.getBroker(BROKER_B_NAME).waitUntilStarted();
        Thread.sleep(1000L);
        this.setClientUrl("failover:(tcp://127.0.0.1:61616,tcp://127.0.0.1:61617)?randomize=false&priorityBackup=true&initialReconnectDelay=1000&useExponentialBackOff=false");
        this.createClients(5);
        this.assertAllConnectedTo(this.urls.get(BROKER_A_NAME));
        this.restart(false, BROKER_A_NAME, BROKER_B_NAME);
        for (int i = 0; i < 3; ++i) {
            this.restart(true, BROKER_A_NAME, BROKER_B_NAME);
        }
        Thread.sleep(5000L);
        this.restart(false, BROKER_A_NAME, BROKER_B_NAME);
    }

    public void testPriorityBackupList() throws Exception {
        this.createBrokerA();
        this.createBrokerB();
        this.getBroker(BROKER_B_NAME).waitUntilStarted();
        Thread.sleep(1000L);
        this.setClientUrl("failover:(tcp://127.0.0.1:61616,tcp://127.0.0.1:61617)?randomize=false&priorityBackup=true&priorityURIs=tcp://127.0.0.1:61617&initialReconnectDelay=1000&useExponentialBackOff=false");
        this.createClients(5);
        Thread.sleep(3000L);
        this.assertAllConnectedTo(this.urls.get(BROKER_B_NAME));
        this.restart(false, BROKER_B_NAME, BROKER_A_NAME);
        for (int i = 0; i < 3; ++i) {
            this.restart(true, BROKER_B_NAME, BROKER_A_NAME);
        }
        this.restart(false, BROKER_B_NAME, BROKER_A_NAME);
    }

    private void restart(boolean primary, String primaryName, String secondaryName) throws Exception {
        Thread.sleep(1000L);
        if (primary) {
            this.LOG.info("Stopping " + primaryName);
            this.stopBroker(primaryName);
        } else {
            this.LOG.info("Stopping " + secondaryName);
            this.stopBroker(secondaryName);
        }
        Thread.sleep(5000L);
        if (primary) {
            this.assertAllConnectedTo(this.urls.get(secondaryName));
        } else {
            this.assertAllConnectedTo(this.urls.get(primaryName));
        }
        if (primary) {
            this.LOG.info("Starting " + primaryName);
            this.createBrokerByName(primaryName);
            this.getBroker(primaryName).waitUntilStarted();
        } else {
            this.LOG.info("Starting " + secondaryName);
            this.createBrokerByName(secondaryName);
            this.getBroker(secondaryName).waitUntilStarted();
        }
        Thread.sleep(5000L);
        this.assertAllConnectedTo(this.urls.get(primaryName));
    }

    private void createBrokerByName(String name) throws Exception {
        if (name.equals(BROKER_A_NAME)) {
            this.createBrokerA();
        } else if (name.equals(BROKER_B_NAME)) {
            this.createBrokerB();
        } else {
            throw new Exception("Unknown broker " + name);
        }
    }

    private void createBrokerA() throws Exception {
        if (this.getBroker(BROKER_A_NAME) == null) {
            this.addBroker(BROKER_A_NAME, this.createBroker(BROKER_A_NAME));
            this.addTransportConnector(this.getBroker(BROKER_A_NAME), "openwire", BROKER_A_CLIENT_TC_ADDRESS, false);
            this.addNetworkBridge(this.getBroker(BROKER_A_NAME), "A_2_B_Bridge", "static://(tcp://127.0.0.1:61617)?useExponentialBackOff=false", false, null);
            this.getBroker(BROKER_A_NAME).start();
        }
    }

    private void createBrokerB() throws Exception {
        if (this.getBroker(BROKER_B_NAME) == null) {
            this.addBroker(BROKER_B_NAME, this.createBroker(BROKER_B_NAME));
            this.addTransportConnector(this.getBroker(BROKER_B_NAME), "openwire", BROKER_B_CLIENT_TC_ADDRESS, false);
            this.addNetworkBridge(this.getBroker(BROKER_B_NAME), "B_2_A_Bridge", "static://(tcp://127.0.0.1:61616)?useExponentialBackOff=false", false, null);
            this.getBroker(BROKER_B_NAME).start();
        }
    }

    protected void tearDown() throws Exception {
        this.shutdownClients();
        this.destroyBrokerCluster();
    }
}

