/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.IOException;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.transport.failover.FailoverTransactionTest;

public class FailoverRedeliveryTransactionTest
extends FailoverTransactionTest {
    public static Test suite() {
        return FailoverRedeliveryTransactionTest.suite(FailoverRedeliveryTransactionTest.class);
    }

    @Override
    public void configureConnectionFactory(ActiveMQConnectionFactory factory) {
        super.configureConnectionFactory(factory);
        factory.setTransactedIndividualAck(true);
    }

    @Override
    public BrokerService createBroker(boolean deleteAllMessagesOnStartup, String bindAddress) throws Exception {
        BrokerService brokerService = super.createBroker(deleteAllMessagesOnStartup, bindAddress);
        this.configurePersistenceAdapter(brokerService);
        return brokerService;
    }

    private void configurePersistenceAdapter(BrokerService brokerService) throws IOException {
        KahaDBPersistenceAdapter kahaDBPersistenceAdapter = (KahaDBPersistenceAdapter)brokerService.getPersistenceAdapter();
        kahaDBPersistenceAdapter.setRewriteOnRedelivery(true);
    }

    @Override
    public PersistenceAdapter setDefaultPersistenceAdapter(BrokerService broker) throws IOException {
        PersistenceAdapter persistenceAdapter = super.setDefaultPersistenceAdapter(broker);
        this.configurePersistenceAdapter(broker);
        return persistenceAdapter;
    }

    @Override
    public void testFailoverProducerCloseBeforeTransaction() throws Exception {
    }

    @Override
    public void initCombosForTestFailoverCommitReplyLost() {
    }

    @Override
    public void testFailoverCommitReplyLost() throws Exception {
    }

    @Override
    public void testFailoverCommitReplyLostWithDestinationPathSeparator() throws Exception {
    }

    @Override
    public void initCombosForTestFailoverSendReplyLost() {
    }

    @Override
    public void testFailoverSendReplyLost() throws Exception {
    }

    @Override
    public void initCombosForTestFailoverConnectionSendReplyLost() {
    }

    @Override
    public void testFailoverConnectionSendReplyLost() throws Exception {
    }

    @Override
    public void testFailoverProducerCloseBeforeTransactionFailWhenDisabled() throws Exception {
    }

    @Override
    public void testFailoverMultipleProducerCloseBeforeTransaction() throws Exception {
    }
}

