/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.IOException;
import java.net.URI;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.state.ConnectionStateTracker;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class FailoverTransportTest {
    protected Transport transport;
    protected FailoverTransport failoverTransport;

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        if (this.transport != null) {
            this.transport.stop();
        }
    }

    @Test(timeout=30000L)
    @Ignore(value="Test fails on windows")
    public void testReconnectUnlimited() throws Exception {
        Transport transport = TransportFactory.connect((URI)new URI("failover://(tcp://0.0.0.0:61616)?useExponentialBackOff=false&reconnectDelay=0&initialReconnectDelay=0"));
        transport.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
            }

            public void onException(IOException error) {
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        transport.start();
        this.failoverTransport = (FailoverTransport)transport.narrow(FailoverTransport.class);
        Assert.assertTrue((String)"no implicit limit of 1000", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return FailoverTransportTest.this.failoverTransport.getConnectFailures() > 1002;
            }
        }));
    }

    @Test(timeout=30000L)
    public void testCommandsIgnoredWhenOffline() throws Exception {
        this.transport = this.createTransport();
        Assert.assertNotNull((Object)this.failoverTransport);
        ConnectionStateTracker tracker = this.failoverTransport.getStateTracker();
        Assert.assertNotNull((Object)tracker);
        ConnectionId id = new ConnectionId("1");
        ConnectionInfo connection = new ConnectionInfo(id);
        tracker.track((Command)connection);
        try {
            this.transport.oneway((Object)new RemoveInfo((DataStructure)new ConnectionId("1")));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not have failed to remove this known connection");
        }
        try {
            this.transport.oneway((Object)new RemoveInfo((DataStructure)new ConnectionId("2")));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not have failed to remove this unknown connection");
        }
        this.transport.oneway((Object)new MessageAck());
        this.transport.oneway((Object)new ShutdownInfo());
    }

    @Test(timeout=30000L)
    public void testResponsesSentWhenRequestForIgnoredCommands() throws Exception {
        this.transport = this.createTransport();
        Assert.assertNotNull((Object)this.failoverTransport);
        MessageAck ack = new MessageAck();
        Assert.assertNotNull((String)"Should have received a Response", (Object)this.transport.request((Object)ack));
        RemoveInfo info = new RemoveInfo((DataStructure)new ConnectionId("2"));
        Assert.assertNotNull((String)"Should have received a Response", (Object)this.transport.request((Object)info));
    }

    protected Transport createTransport() throws Exception {
        Transport transport = TransportFactory.connect((URI)new URI("failover://(tcp://localhost:1234?transport.connectTimeout=10000)"));
        transport.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
            }

            public void onException(IOException error) {
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        transport.start();
        this.failoverTransport = (FailoverTransport)transport.narrow(FailoverTransport.class);
        return transport;
    }
}

