/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitalReconnectDelayTest {
    private static final transient Logger LOG = LoggerFactory.getLogger(InitalReconnectDelayTest.class);
    protected BrokerService broker1;
    protected BrokerService broker2;
    protected CountDownLatch broker2Started = new CountDownLatch(1);
    protected String uriString = "failover://(tcp://localhost:62001,tcp://localhost:62002)?randomize=false&initialReconnectDelay=15000";

    @Test
    public void testInitialReconnectDelay() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.uriString);
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue("foo");
        MessageProducer producer = session.createProducer((Destination)destination);
        long start = new Date().getTime();
        producer.send((Message)session.createTextMessage("TEST"));
        long end = new Date().getTime();
        Assert.assertTrue((end - start < 2000L ? 1 : 0) != 0);
        LOG.info("Stopping the Broker1...");
        start = new Date().getTime();
        this.broker1.stop();
        LOG.info("Attempting to send... failover should kick in...");
        producer.send((Message)session.createTextMessage("TEST"));
        end = new Date().getTime();
        LOG.info("Failover took " + (end - start) + " ms.");
        Assert.assertTrue((String)("Failover took " + (end - start) + " ms and should be > 14000."), (end - start > 14000L ? 1 : 0) != 0);
    }

    @Before
    public void setUp() throws Exception {
        String dataDir = "target/data/shared";
        this.broker1 = new BrokerService();
        this.broker1.setBrokerName("broker1");
        this.broker1.setDeleteAllMessagesOnStartup(true);
        this.broker1.setDataDirectory("target/data/shared");
        this.broker1.addConnector("tcp://localhost:62001");
        this.broker1.setUseJmx(false);
        this.broker1.start();
        this.broker1.waitUntilStarted();
        this.broker2 = new BrokerService();
        this.broker2.setBrokerName("broker2");
        this.broker2.setDataDirectory("target/data/shared");
        this.broker2.setUseJmx(false);
        this.broker2.addConnector("tcp://localhost:62002");
        this.broker2.start();
        this.broker2.waitUntilStarted();
    }

    protected String getSlaveXml() {
        return "org/apache/activemq/broker/ft/sharedFileSlave.xml";
    }

    protected String getMasterXml() {
        return "org/apache/activemq/broker/ft/sharedFileMaster.xml";
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker1.isStarted()) {
            this.broker1.stop();
            this.broker1.waitUntilStopped();
        }
        if (this.broker2.isStarted()) {
            this.broker2.stop();
            this.broker2.waitUntilStopped();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.uriString);
    }
}

