/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerThread.class);
    int messageCount = 1000;
    int received = 0;
    Destination dest;
    Session sess;
    boolean breakOnNull = true;

    public ConsumerThread(Session sess, Destination dest) {
        this.dest = dest;
        this.sess = sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MessageConsumer consumer = null;
        try {
            consumer = this.sess.createConsumer(this.dest);
            while (this.received < this.messageCount) {
                Message msg = consumer.receive(3000L);
                if (msg != null) {
                    LOG.info("Received " + ((TextMessage)msg).getText());
                    ++this.received;
                    continue;
                }
                if (!this.breakOnNull) continue;
                break;
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        finally {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int getReceived() {
        return this.received;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public void setBreakOnNull(boolean breakOnNull) {
        this.breakOnNull = breakOnNull;
    }
}

