/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQOutputStream;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQInputStreamTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQInputStreamTest.class);
    private static final String BROKER_URL = "tcp://localhost:0";
    private static final String DESTINATION = "destination";
    private static final int STREAM_LENGTH = 65536;
    private BrokerService broker;
    private String connectionUri;

    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistent(false);
        this.broker.setDestinations(new ActiveMQDestination[]{ActiveMQDestination.createDestination((String)DESTINATION, (byte)1)});
        this.broker.addConnector(BROKER_URL);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    public void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamSetSyncSendOption() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue("destination?producer.alwaysSyncSend=true");
        OutputStream out = null;
        try {
            out = connection.createOutputStream((Destination)destination);
            ActiveMQInputStreamTest.assertTrue((boolean)((ActiveMQOutputStream)out).isAlwaysSyncSend());
            LOG.debug("writing...");
            for (int i = 0; i < 65536; ++i) {
                out.write(0);
            }
            LOG.debug("wrote 65536 bytes");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        InputStream in = null;
        try {
            in = connection.createInputStream((Destination)destination);
            LOG.debug("reading...");
            int count = 0;
            while (-1 != in.read()) {
                ++count;
            }
            LOG.debug("read " + count + " bytes");
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamMatchesDefaultChuckSize() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(DESTINATION);
        OutputStream out = null;
        try {
            out = connection.createOutputStream((Destination)destination);
            LOG.debug("writing...");
            for (int i = 0; i < 65536; ++i) {
                out.write(0);
            }
            LOG.debug("wrote 65536 bytes");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        InputStream in = null;
        try {
            in = connection.createInputStream((Destination)destination);
            LOG.debug("reading...");
            int count = 0;
            while (-1 != in.read()) {
                ++count;
            }
            LOG.debug("read " + count + " bytes");
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        connection.close();
    }
}

