/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ft.DbRestartJDBCQueueMasterSlaveLeaseTest;
import org.apache.activemq.store.jdbc.JDBCIOExceptionHandler;
import org.apache.activemq.util.IOExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbRestartJDBCQueueMasterSlaveLeaseQuiesceTest
extends DbRestartJDBCQueueMasterSlaveLeaseTest {
    private static final transient Logger LOG = LoggerFactory.getLogger(DbRestartJDBCQueueMasterSlaveLeaseQuiesceTest.class);
    private long restartDelay = 500L;

    @Override
    protected void configureBroker(BrokerService brokerService) {
        JDBCIOExceptionHandler stopConnectors = new JDBCIOExceptionHandler();
        brokerService.setIoExceptionHandler((IOExceptionHandler)stopConnectors);
    }

    @Override
    protected void delayTillRestartRequired() {
        if (this.restartDelay > 500L) {
            LOG.info("delay for more than lease quantum. While Db is offline, master should stay alive but could loose lease");
        } else {
            LOG.info("delay for less than lease quantum. While Db is offline, master should stay alive");
        }
        try {
            TimeUnit.MILLISECONDS.sleep(this.restartDelay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void verifyExpectedBroker(int inflightMessageCount) {
        if (inflightMessageCount == 0 || inflightMessageCount == this.failureCount + 10 && this.restartDelay <= 500L) {
            DbRestartJDBCQueueMasterSlaveLeaseQuiesceTest.assertEquals((String)"connected to master", (String)this.master.getBrokerName(), (String)((ActiveMQConnection)this.sendConnection).getBrokerName());
        }
    }

    @Override
    public void setUp() throws Exception {
        this.restartDelay = 500L;
        super.setUp();
    }

    public void testSendReceiveWithLeaseExpiry() throws Exception {
        this.restartDelay = 3000L;
        this.testSendReceive();
    }

    @Override
    public void testAdvisory() throws Exception {
    }
}

