/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.Wait;

public class DestinationGCTest
extends EmbeddedBrokerTestSupport {
    ActiveMQQueue queue = new ActiveMQQueue("TEST");

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        broker.setDestinations(new ActiveMQDestination[]{this.queue});
        broker.setSchedulePeriodForDestinationPurge(1000);
        broker.setMaxPurgedDestinationsPerSweep(1);
        PolicyEntry entry = new PolicyEntry();
        entry.setGcInactiveDestinations(true);
        entry.setInactiveTimoutBeforeGC(3000L);
        PolicyMap map = new PolicyMap();
        map.setDefaultEntry(entry);
        broker.setDestinationPolicy(map);
        return broker;
    }

    public void testDestinationGc() throws Exception {
        DestinationGCTest.assertEquals((int)1, (int)this.broker.getAdminView().getQueues().length);
        DestinationGCTest.assertTrue((String)"After GC runs the Queue should be empty.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DestinationGCTest.this.broker.getAdminView().getQueues().length == 0;
            }
        }));
    }

    public void testDestinationGcLimit() throws Exception {
        this.broker.getAdminView().addQueue("TEST1");
        this.broker.getAdminView().addQueue("TEST2");
        this.broker.getAdminView().addQueue("TEST3");
        this.broker.getAdminView().addQueue("TEST4");
        DestinationGCTest.assertEquals((int)5, (int)this.broker.getAdminView().getQueues().length);
        Thread.sleep(7000L);
        int queues = this.broker.getAdminView().getQueues().length;
        DestinationGCTest.assertTrue((queues > 0 && queues < 5 ? 1 : 0) != 0);
        DestinationGCTest.assertTrue((String)"After GC runs the Queue should be empty.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DestinationGCTest.this.broker.getAdminView().getQueues().length == 0;
            }
        }));
    }
}

