/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URI;
import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import junit.framework.TestCase;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.Connector;
import org.apache.activemq.broker.StubBroker;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.UserPrincipal;
import org.apache.activemq.security.JaasDualAuthenticationBroker;
import org.apache.activemq.security.StubDualJaasConfiguration;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.tcp.SslTransportServer;
import org.apache.activemq.transport.tcp.StubSSLServerSocket;
import org.apache.activemq.transport.tcp.StubSSLSocketFactory;
import org.apache.activemq.transport.tcp.StubX509Certificate;
import org.apache.activemq.transport.tcp.TcpTransportServer;

public class JaasDualAuthenticationBrokerTest
extends TestCase {
    private static final String INSECURE_GROUP = "insecureGroup";
    private static final String INSECURE_USERNAME = "insecureUserName";
    private static final String DN_GROUP = "dnGroup";
    private static final String DN_USERNAME = "dnUserName";
    StubBroker receiveBroker;
    JaasDualAuthenticationBroker authBroker;
    ConnectionContext connectionContext;
    ConnectionInfo connectionInfo;
    SslTransportServer sslTransportServer;
    TcpTransportServer nonSslTransportServer;

    void createLoginConfig() {
        HashMap<String, String> sslConfigOptions = new HashMap<String, String>();
        HashMap<String, String> configOptions = new HashMap<String, String>();
        sslConfigOptions.put("org.apache.activemq.jaas.stubproperties.allow_login", "true");
        sslConfigOptions.put("org.apache.activemq.jaas.stubproperties.users", DN_USERNAME);
        sslConfigOptions.put("org.apache.activemq.jaas.stubproperties.groups", DN_GROUP);
        AppConfigurationEntry sslConfigEntry = new AppConfigurationEntry("org.apache.activemq.security.StubLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, sslConfigOptions);
        configOptions.put("org.apache.activemq.jaas.stubproperties.allow_login", "true");
        configOptions.put("org.apache.activemq.jaas.stubproperties.users", INSECURE_USERNAME);
        configOptions.put("org.apache.activemq.jaas.stubproperties.groups", INSECURE_GROUP);
        AppConfigurationEntry configEntry = new AppConfigurationEntry("org.apache.activemq.security.StubLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, configOptions);
        StubDualJaasConfiguration jaasConfig = new StubDualJaasConfiguration(configEntry, sslConfigEntry);
        Configuration.setConfiguration(jaasConfig);
    }

    protected void setUp() throws Exception {
        this.receiveBroker = new StubBroker();
        this.authBroker = new JaasDualAuthenticationBroker((Broker)this.receiveBroker, "activemq-domain", "activemq-ssl-domain");
        this.connectionContext = new ConnectionContext();
        StubSSLServerSocket sslServerSocket = new StubSSLServerSocket();
        StubSSLSocketFactory socketFactory = new StubSSLSocketFactory(sslServerSocket);
        try {
            this.sslTransportServer = new SslTransportServer(null, new URI("ssl://localhost:61616?needClientAuth=true"), (SSLServerSocketFactory)socketFactory);
        }
        catch (Exception e) {
            JaasDualAuthenticationBrokerTest.fail((String)"Unable to create SslTransportServer.");
        }
        this.sslTransportServer.setNeedClientAuth(true);
        this.sslTransportServer.bind();
        try {
            this.nonSslTransportServer = new TcpTransportServer(null, new URI("tcp://localhost:61613"), (ServerSocketFactory)socketFactory);
        }
        catch (Exception e) {
            JaasDualAuthenticationBrokerTest.fail((String)"Unable to create TcpTransportServer.");
        }
        this.connectionInfo = new ConnectionInfo();
        this.createLoginConfig();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSecureConnector() {
        TransportConnector connector = new TransportConnector((TransportServer)this.sslTransportServer);
        this.connectionContext.setConnector((Connector)connector);
        this.connectionInfo.setTransportContext((Object)new StubX509Certificate[0]);
        try {
            this.authBroker.addConnection(this.connectionContext, this.connectionInfo);
        }
        catch (Exception e) {
            JaasDualAuthenticationBrokerTest.fail((String)("Call to addConnection failed: " + e.getMessage()));
        }
        JaasDualAuthenticationBrokerTest.assertEquals((String)"Number of addConnection calls to underlying Broker must match number of calls made to AuthenticationBroker.", (int)1, (int)this.receiveBroker.addConnectionData.size());
        ConnectionContext receivedContext = this.receiveBroker.addConnectionData.getFirst().connectionContext;
        JaasDualAuthenticationBrokerTest.assertEquals((String)"The SecurityContext's userName must be set to that of the UserPrincipal.", (String)DN_USERNAME, (String)receivedContext.getSecurityContext().getUserName());
        Set receivedPrincipals = receivedContext.getSecurityContext().getPrincipals();
        JaasDualAuthenticationBrokerTest.assertEquals((String)"2 Principals received", (int)2, (int)receivedPrincipals.size());
        for (Principal currentPrincipal : receivedPrincipals) {
            if (currentPrincipal instanceof UserPrincipal) {
                JaasDualAuthenticationBrokerTest.assertEquals((String)"UserPrincipal is 'dnUserName'", (String)DN_USERNAME, (String)currentPrincipal.getName());
                continue;
            }
            if (currentPrincipal instanceof GroupPrincipal) {
                JaasDualAuthenticationBrokerTest.assertEquals((String)"GroupPrincipal is 'dnGroup'", (String)DN_GROUP, (String)currentPrincipal.getName());
                continue;
            }
            JaasDualAuthenticationBrokerTest.fail((String)"Unexpected Principal subclass found.");
        }
        try {
            this.authBroker.removeConnection(this.connectionContext, this.connectionInfo, null);
        }
        catch (Exception e) {
            JaasDualAuthenticationBrokerTest.fail((String)("Call to removeConnection failed: " + e.getMessage()));
        }
        JaasDualAuthenticationBrokerTest.assertEquals((String)"Number of removeConnection calls to underlying Broker must match number of calls made to AuthenticationBroker.", (int)1, (int)this.receiveBroker.removeConnectionData.size());
    }

    public void testInsecureConnector() {
        TransportConnector connector = new TransportConnector((TransportServer)this.nonSslTransportServer);
        this.connectionContext.setConnector((Connector)connector);
        this.connectionInfo.setUserName(INSECURE_USERNAME);
        try {
            this.authBroker.addConnection(this.connectionContext, this.connectionInfo);
        }
        catch (Exception e) {
            JaasDualAuthenticationBrokerTest.fail((String)("Call to addConnection failed: " + e.getMessage()));
        }
        JaasDualAuthenticationBrokerTest.assertEquals((String)"Number of addConnection calls to underlying Broker must match number of calls made to AuthenticationBroker.", (int)1, (int)this.receiveBroker.addConnectionData.size());
        ConnectionContext receivedContext = this.receiveBroker.addConnectionData.getFirst().connectionContext;
        JaasDualAuthenticationBrokerTest.assertEquals((String)"The SecurityContext's userName must be set to that of the UserPrincipal.", (String)INSECURE_USERNAME, (String)receivedContext.getSecurityContext().getUserName());
        Set receivedPrincipals = receivedContext.getSecurityContext().getPrincipals();
        JaasDualAuthenticationBrokerTest.assertEquals((String)"2 Principals received", (int)2, (int)receivedPrincipals.size());
        for (Principal currentPrincipal : receivedPrincipals) {
            if (currentPrincipal instanceof UserPrincipal) {
                JaasDualAuthenticationBrokerTest.assertEquals((String)"UserPrincipal is 'insecureUserName'", (String)INSECURE_USERNAME, (String)currentPrincipal.getName());
                continue;
            }
            if (currentPrincipal instanceof GroupPrincipal) {
                JaasDualAuthenticationBrokerTest.assertEquals((String)"GroupPrincipal is 'insecureGroup'", (String)INSECURE_GROUP, (String)currentPrincipal.getName());
                continue;
            }
            JaasDualAuthenticationBrokerTest.fail((String)"Unexpected Principal subclass found.");
        }
        try {
            this.authBroker.removeConnection(this.connectionContext, this.connectionInfo, null);
        }
        catch (Exception e) {
            JaasDualAuthenticationBrokerTest.fail((String)("Call to removeConnection failed: " + e.getMessage()));
        }
        JaasDualAuthenticationBrokerTest.assertEquals((String)"Number of removeConnection calls to underlying Broker must match number of calls made to AuthenticationBroker.", (int)1, (int)this.receiveBroker.removeConnectionData.size());
    }
}

