/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.cursors.NegativeQueueTest;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class JDBCNegativeQueueTest
extends NegativeQueueTest {
    EmbeddedDataSource dataSource;

    @Override
    protected void configureBroker(BrokerService answer) throws Exception {
        super.configureBroker(answer);
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        this.dataSource = new EmbeddedDataSource();
        this.dataSource.setDatabaseName("derbyDb");
        this.dataSource.setCreateDatabase("create");
        jdbc.setDataSource((DataSource)this.dataSource);
        answer.setPersistenceAdapter((PersistenceAdapter)jdbc);
    }

    @Override
    protected void tearDown() throws Exception {
        this.printQuery("Select * from ACTIVEMQ_MSGS", System.out);
        super.tearDown();
    }

    private void printQuery(String query, PrintStream out) throws SQLException {
        Connection conn = this.dataSource.getConnection();
        this.printQuery(conn.prepareStatement(query), out);
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printQuery(PreparedStatement s, PrintStream out) throws SQLException {
        ResultSet set = null;
        try {
            int i;
            set = s.executeQuery();
            ResultSetMetaData metaData = set.getMetaData();
            for (i = 1; i <= metaData.getColumnCount(); ++i) {
                if (i == 1) {
                    out.print("||");
                }
                out.print(metaData.getColumnName(i) + "||");
            }
            out.println();
            while (set.next()) {
                for (i = 1; i <= metaData.getColumnCount(); ++i) {
                    if (i == 1) {
                        out.print("|");
                    }
                    out.print(set.getString(i) + "|");
                }
                out.println();
            }
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable ignore) {}
            try {
                s.close();
            }
            catch (Throwable ignore) {}
        }
    }
}

