/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.NetworkConnector;

public class FailoverClusterTest
extends TestCase {
    private static final int NUMBER = 10;
    private static final String BROKER_BIND_ADDRESS = "tcp://0.0.0.0:0";
    private static final String BROKER_A_NAME = "BROKERA";
    private static final String BROKER_B_NAME = "BROKERB";
    private BrokerService brokerA;
    private BrokerService brokerB;
    private String clientUrl;
    private final List<ActiveMQConnection> connections = new ArrayList<ActiveMQConnection>();

    public void testClusterConnectedAfterClients() throws Exception {
        this.createClients();
        if (this.brokerB == null) {
            this.brokerB = this.createBrokerB(BROKER_BIND_ADDRESS);
        }
        Thread.sleep(3000L);
        HashSet<String> set = new HashSet<String>();
        for (ActiveMQConnection c : this.connections) {
            set.add(c.getTransportChannel().getRemoteAddress());
        }
        FailoverClusterTest.assertTrue((set.size() > 1 ? 1 : 0) != 0);
    }

    public void testClusterURIOptionsStrip() throws Exception {
        this.createClients();
        if (this.brokerB == null) {
            this.brokerB = this.createBrokerB("tcp://0.0.0.0:0?transport.closeAsync=false");
        }
        Thread.sleep(3000L);
        HashSet<String> set = new HashSet<String>();
        for (ActiveMQConnection c : this.connections) {
            set.add(c.getTransportChannel().getRemoteAddress());
        }
        FailoverClusterTest.assertTrue((set.size() > 1 ? 1 : 0) != 0);
    }

    public void testClusterConnectedBeforeClients() throws Exception {
        if (this.brokerB == null) {
            this.brokerB = this.createBrokerB(BROKER_BIND_ADDRESS);
        }
        Thread.sleep(5000L);
        this.createClients();
        Thread.sleep(2000L);
        this.brokerA.stop();
        Thread.sleep(2000L);
        URI brokerBURI = new URI(((TransportConnector)this.brokerB.getTransportConnectors().get(0)).getPublishableConnectString());
        for (ActiveMQConnection c : this.connections) {
            String addr = c.getTransportChannel().getRemoteAddress();
            FailoverClusterTest.assertTrue((addr.indexOf("" + brokerBURI.getPort()) > 0 ? 1 : 0) != 0);
        }
    }

    protected void setUp() throws Exception {
        if (this.brokerA == null) {
            this.brokerA = this.createBrokerA("tcp://0.0.0.0:0?transport.closeAsync=false");
            this.clientUrl = "failover://(" + ((TransportConnector)this.brokerA.getTransportConnectors().get(0)).getPublishableConnectString() + ")";
        }
    }

    protected void tearDown() throws Exception {
        for (ActiveMQConnection c : this.connections) {
            c.close();
        }
        if (this.brokerB != null) {
            this.brokerB.stop();
            this.brokerB = null;
        }
        if (this.brokerA != null) {
            this.brokerA.stop();
            this.brokerA = null;
        }
    }

    protected BrokerService createBrokerA(String uri) throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(false);
        this.configureConsumerBroker(answer, uri);
        answer.start();
        return answer;
    }

    protected void configureConsumerBroker(BrokerService answer, String uri) throws Exception {
        answer.setBrokerName(BROKER_A_NAME);
        answer.setPersistent(false);
        TransportConnector connector = answer.addConnector(uri);
        connector.setRebalanceClusterClients(true);
        connector.setUpdateClusterClients(true);
        answer.setUseShutdownHook(false);
    }

    protected BrokerService createBrokerB(String uri) throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(false);
        this.configureNetwork(answer, uri);
        answer.start();
        return answer;
    }

    protected void configureNetwork(BrokerService answer, String uri) throws Exception {
        answer.setBrokerName(BROKER_B_NAME);
        answer.setPersistent(false);
        NetworkConnector network = answer.addNetworkConnector("static://" + ((TransportConnector)this.brokerA.getTransportConnectors().get(0)).getPublishableConnectString());
        network.setDuplex(true);
        TransportConnector connector = answer.addConnector(uri);
        connector.setRebalanceClusterClients(true);
        connector.setUpdateClusterClients(true);
        answer.setUseShutdownHook(false);
    }

    protected void createClients() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.clientUrl);
        for (int i = 0; i < 10; ++i) {
            ActiveMQConnection c = (ActiveMQConnection)factory.createConnection();
            c.start();
            Session s = c.createSession(false, 1);
            Queue queue = s.createQueue(((Object)((Object)this)).getClass().getName());
            MessageConsumer consumer = s.createConsumer((Destination)queue);
            this.connections.add(c);
        }
    }
}

