/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import org.apache.activemq.transport.failover.FailoverClusterTestSupport;

public class TwoBrokerFailoverClusterTest
extends FailoverClusterTestSupport {
    private static final String BROKER_A_CLIENT_TC_ADDRESS = "tcp://127.0.0.1:61616";
    private static final String BROKER_B_CLIENT_TC_ADDRESS = "tcp://127.0.0.1:61617";
    private static final String BROKER_A_NOB_TC_ADDRESS = "tcp://127.0.0.1:61626";
    private static final String BROKER_B_NOB_TC_ADDRESS = "tcp://127.0.0.1:61627";
    private static final String BROKER_A_NAME = "BROKERA";
    private static final String BROKER_B_NAME = "BROKERB";

    public void testTwoBrokersRestart() throws Exception {
        this.createBrokerA(false, "", null, null);
        this.createBrokerB(false, "", null, null);
        this.getBroker(BROKER_B_NAME).waitUntilStarted();
        Thread.sleep(2000L);
        this.setClientUrl("failover://(tcp://127.0.0.1:61616,tcp://127.0.0.1:61617)");
        this.createClients();
        Thread.sleep(5000L);
        this.assertClientsConnectedToTwoBrokers();
        this.assertClientsConnectionsEvenlyDistributed(0.35);
        this.getBroker(BROKER_A_NAME).stop();
        this.getBroker(BROKER_A_NAME).waitUntilStopped();
        this.removeBroker(BROKER_A_NAME);
        this.assertAllConnectedTo(BROKER_B_CLIENT_TC_ADDRESS);
        Thread.sleep(5000L);
        this.createBrokerA(false, "", null, null);
        this.getBroker(BROKER_A_NAME).waitUntilStarted();
        Thread.sleep(5000L);
        this.assertClientsConnectedToTwoBrokers();
        this.assertClientsConnectionsEvenlyDistributed(0.35);
    }

    private void createBrokerA(boolean multi, String params, String clusterFilter, String destinationFilter) throws Exception {
        String tcParams;
        String string = tcParams = params == null ? "" : params;
        if (this.getBroker(BROKER_A_NAME) == null) {
            this.addBroker(BROKER_A_NAME, this.createBroker(BROKER_A_NAME));
            this.addTransportConnector(this.getBroker(BROKER_A_NAME), "openwire", BROKER_A_CLIENT_TC_ADDRESS + tcParams, true);
            if (multi) {
                this.addTransportConnector(this.getBroker(BROKER_A_NAME), "network", BROKER_A_NOB_TC_ADDRESS + tcParams, false);
                this.addNetworkBridge(this.getBroker(BROKER_A_NAME), "A_2_B_Bridge", "static://(tcp://127.0.0.1:61627)?useExponentialBackOff=false", false, clusterFilter);
            } else {
                this.addNetworkBridge(this.getBroker(BROKER_A_NAME), "A_2_B_Bridge", "static://(tcp://127.0.0.1:61617)?useExponentialBackOff=false", false, clusterFilter);
            }
            this.getBroker(BROKER_A_NAME).start();
        }
    }

    private void createBrokerB(boolean multi, String params, String clusterFilter, String destinationFilter) throws Exception {
        String tcParams;
        String string = tcParams = params == null ? "" : params;
        if (this.getBroker(BROKER_B_NAME) == null) {
            this.addBroker(BROKER_B_NAME, this.createBroker(BROKER_B_NAME));
            this.addTransportConnector(this.getBroker(BROKER_B_NAME), "openwire", BROKER_B_CLIENT_TC_ADDRESS + tcParams, true);
            if (multi) {
                this.addTransportConnector(this.getBroker(BROKER_B_NAME), "network", BROKER_B_NOB_TC_ADDRESS + tcParams, false);
                this.addNetworkBridge(this.getBroker(BROKER_B_NAME), "B_2_A_Bridge", "static://(tcp://127.0.0.1:61626)?useExponentialBackOff=false", false, clusterFilter);
            } else {
                this.addNetworkBridge(this.getBroker(BROKER_B_NAME), "B_2_A_Bridge", "static://(tcp://127.0.0.1:61616)?useExponentialBackOff=false", false, clusterFilter);
            }
            this.getBroker(BROKER_B_NAME).start();
        }
    }
}

