/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;

public class NIOSSLWindowSizeTest
extends TestCase {
    BrokerService broker;
    Connection connection;
    Session session;
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    public static final int PRODUCER_COUNT = 1;
    public static final int CONSUMER_COUNT = 1;
    public static final int MESSAGE_COUNT = 1;
    public static final int MESSAGE_SIZE = 65536;
    byte[] messageData;

    protected void setUp() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        TransportConnector connector = this.broker.addConnector("nio+ssl://localhost:0?transport.needClientAuth=true");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.messageData = new byte[65536];
        for (int i = 0; i < 65536; ++i) {
            this.messageData[i] = (byte)(i & 0xFF);
        }
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("nio+ssl://localhost:" + connector.getConnectUri().getPort());
        this.connection = factory.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLargePayload() throws Exception {
        Queue dest = this.session.createQueue("TEST");
        MessageProducer prod = null;
        try {
            prod = this.session.createProducer((Destination)dest);
            BytesMessage msg = this.session.createBytesMessage();
            msg.writeBytes(this.messageData);
            prod.send((Message)msg);
        }
        finally {
            prod.close();
        }
        MessageConsumer cons = null;
        try {
            cons = this.session.createConsumer((Destination)dest);
            NIOSSLWindowSizeTest.assertNotNull((Object)cons.receive(30000L));
        }
        finally {
            cons.close();
        }
    }
}

