/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableSubDelayedUnsubscribeTest {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubDelayedUnsubscribeTest.class);
    private static final long RUNTIME = 120000L;
    private static final int CARGO_SIZE = 400;
    private static final int MAX_CLIENTS = 15;
    private static boolean ALLOW_SUBSCRIPTION_ABANDONMENT = true;
    private static final Vector<Throwable> exceptions = new Vector();
    private BrokerService broker;
    private ActiveMQTopic topic;
    private ClientManager clientManager;
    private Server server;
    private HouseKeeper houseKeeper;
    private final ReentrantReadWriteLock processLock = new ReentrantReadWriteLock(true);

    @Test
    public void testProcess() throws Exception {
        this.server.start();
        this.clientManager.start();
        this.houseKeeper.start();
        Thread.sleep(120000L);
        this.server.stopped = true;
        Client lastClient = new Client(32000, ClientType.A);
        lastClient.process(1000L);
        this.clientManager.stopped = true;
        final BrokerService brokerService = this.broker;
        Assert.assertTrue((String)("should have only one inactiveSubscriber subscribed but was: " + brokerService.getAdminView().getInactiveDurableTopicSubscribers().length), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return brokerService.getAdminView().getInactiveDurableTopicSubscribers().length == 1;
            }
        }, (long)TimeUnit.MINUTES.toMillis(this.houseKeeper.SWEEP_DELAY * 2L)));
        Assert.assertTrue((String)("should be no subscribers subscribed but was: " + brokerService.getAdminView().getDurableTopicSubscribers().length), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return brokerService.getAdminView().getDurableTopicSubscribers().length == 0;
            }
        }, (long)TimeUnit.MINUTES.toMillis(3L)));
        this.processLock.writeLock().lock();
        ObjectName[] subscribers = this.broker.getAdminView().getDurableTopicSubscribers();
        ObjectName[] inactiveSubscribers = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        KahaDBPersistenceAdapter persistenceAdapter = (KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
        this.printDebugClientInfo(subscribers, inactiveSubscribers, persistenceAdapter);
        Assert.assertEquals((String)"should have only one inactiveSubscriber subscribed", (long)1L, (long)this.broker.getAdminView().getInactiveDurableTopicSubscribers().length);
        Assert.assertEquals((String)"should be no subscribers subscribed", (long)0L, (long)this.broker.getAdminView().getDurableTopicSubscribers().length);
        final KahaDBPersistenceAdapter pa = (KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
        Assert.assertTrue((String)("should be less than 3 journal file left but was: " + persistenceAdapter.getStore().getJournal().getFileMap().size()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return pa.getStore().getJournal().getFileMap().size() <= 3;
            }
        }, (long)TimeUnit.MINUTES.toMillis(3L)));
        this.houseKeeper.shutdown();
        Assert.assertTrue((String)("no exceptions: " + exceptions), (boolean)exceptions.isEmpty());
        LOG.info("DONE.");
    }

    private void printDebugClientInfo(ObjectName[] subscribers, ObjectName[] inactiveSubscribers, KahaDBPersistenceAdapter pa) throws IOException {
        int i;
        LOG.info("====>>> START DEBUG Subscriber INFO");
        LOG.info("Number of subscribers subscribed as seen through JMX is" + subscribers.length);
        for (i = 0; i < subscribers.length; ++i) {
            LOG.info("subscribers subscribed as seen throngh JMX: " + subscribers[i]);
        }
        LOG.info("Number of inactiveSubscribers subscribed as seen through JMX is" + inactiveSubscribers.length);
        for (i = 0; i < inactiveSubscribers.length; ++i) {
            LOG.info("subscribers subscribed as seen throngh JMX: " + inactiveSubscribers[i]);
        }
        LOG.info("ClientManager.clients size is" + this.clientManager.clients.size());
        for (i = 0; i < this.clientManager.clients.size(); ++i) {
            LOG.info("clients is: " + this.clientManager.clients.get(i));
        }
        LOG.info("housekeep.subscriptions size is " + this.houseKeeper.abandonedSubscriptions.size());
        for (i = 0; i < this.houseKeeper.abandonedSubscriptions.size(); ++i) {
            LOG.info("housekeep is: " + this.houseKeeper.abandonedSubscriptions.get(i));
        }
        LOG.info("number of journal files left" + pa.getStore().getJournal().getFileMap().size());
        LOG.info("====>>> END DEBUG Subscriber INFO");
    }

    public static int random(int max) {
        return (int)(Math.random() * (double)(max + 1));
    }

    public static int random(int min, int max) {
        return DurableSubDelayedUnsubscribeTest.random(max - min) + min;
    }

    public static void sleepRandom(int maxMillis) throws InterruptedException {
        Thread.sleep(DurableSubDelayedUnsubscribeTest.random(maxMillis));
    }

    public static void sleepRandom(int minMillis, int maxMillis) throws InterruptedException {
        Thread.sleep(DurableSubDelayedUnsubscribeTest.random(minMillis, maxMillis));
    }

    public static void exit(String message) {
        DurableSubDelayedUnsubscribeTest.exit(message, null);
    }

    public static void exit(String message, Throwable e) {
        RuntimeException cause = new RuntimeException(message, e);
        LOG.error(message, (Throwable)cause);
        exceptions.add(cause);
        Assert.fail((String)cause.toString());
    }

    @Before
    public void setUp() throws Exception {
        this.topic = new ActiveMQTopic("TopicT");
        this.startBroker();
        this.clientManager = new ClientManager();
        this.server = new Server();
        this.houseKeeper = new HouseKeeper();
    }

    @After
    public void tearDown() throws Exception {
        this.destroyBroker();
    }

    private void startBroker() throws Exception {
        this.startBroker(true);
    }

    private void startBroker(boolean deleteAllMessages) throws Exception {
        if (this.broker != null) {
            return;
        }
        this.broker = BrokerFactory.createBroker((String)("broker:(vm://" + DurableSubDelayedUnsubscribeTest.getName() + ")"));
        this.broker.setBrokerName(DurableSubDelayedUnsubscribeTest.getName());
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        File kahadbData = new File("activemq-data/" + DurableSubDelayedUnsubscribeTest.getName() + "-kahadb");
        if (deleteAllMessages) {
            DurableSubDelayedUnsubscribeTest.delete(kahadbData);
        }
        this.broker.setPersistent(true);
        KahaDBPersistenceAdapter kahadb = new KahaDBPersistenceAdapter();
        kahadb.setDirectory(kahadbData);
        kahadb.setJournalMaxFileLength(524288);
        this.broker.setPersistenceAdapter((PersistenceAdapter)kahadb);
        this.broker.addConnector("tcp://localhost:61656");
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x10000000L);
        this.broker.getSystemUsage().getTempUsage().setLimit(0x10000000L);
        this.broker.getSystemUsage().getStoreUsage().setLimit(0x10000000L);
        this.broker.start();
    }

    protected static String getName() {
        return "DurableSubProcessWithRestartTest";
    }

    private static boolean delete(File path) {
        if (path == null) {
            return true;
        }
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                DurableSubDelayedUnsubscribeTest.delete(file);
            }
        }
        return path.delete();
    }

    private void destroyBroker() throws Exception {
        if (this.broker == null) {
            return;
        }
        this.broker.stop();
        this.broker = null;
    }

    public static final class Random {
        final int min;
        final int max;

        Random(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int next() {
            return DurableSubDelayedUnsubscribeTest.random(this.min, this.max);
        }

        public void sleepRandom() throws InterruptedException {
            DurableSubDelayedUnsubscribeTest.sleepRandom(this.min, this.max);
        }
    }

    private final class HouseKeeper
    extends Thread {
        private final AtomicBoolean done;
        public final long SWEEP_DELAY;
        public final CopyOnWriteArrayList<String> abandonedSubscriptions;

        private HouseKeeper() {
            super("HouseKeeper");
            this.done = new AtomicBoolean();
            this.SWEEP_DELAY = TimeUnit.MINUTES.toMillis(3L);
            this.abandonedSubscriptions = new CopyOnWriteArrayList();
            this.setDaemon(true);
        }

        public void shutdown() throws Exception {
            this.done.set(true);
            this.interrupt();
            this.join(TimeUnit.MINUTES.toMillis(this.SWEEP_DELAY));
            if (!this.abandonedSubscriptions.isEmpty()) {
                this.sweep();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.done.get()) {
                try {
                    Thread.sleep(this.SWEEP_DELAY);
                    DurableSubDelayedUnsubscribeTest.this.processLock.readLock().lock();
                    try {
                        this.sweep();
                    }
                    finally {
                        DurableSubDelayedUnsubscribeTest.this.processLock.readLock().unlock();
                    }
                }
                catch (InterruptedException ex) {
                    break;
                }
                catch (Throwable e) {
                    Exception log = new Exception("HouseKeeper failed.", e);
                    log.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sweep() throws Exception {
            LOG.info("Housekeeper sweeping.");
            int closed = 0;
            ArrayList<String> sweeped = new ArrayList<String>();
            try {
                for (String clientId : this.abandonedSubscriptions) {
                    LOG.info("Sweeping out subscription of " + clientId + ".");
                    DurableSubDelayedUnsubscribeTest.this.broker.getAdminView().destroyDurableSubscriber(clientId, "subscription");
                    sweeped.add(clientId);
                    ++closed;
                }
            }
            catch (Exception ignored) {
                LOG.info("Ex on destroy sub " + ignored);
            }
            finally {
                this.abandonedSubscriptions.removeAll(sweeped);
            }
            LOG.info("Housekeeper sweeped out " + closed + " subscriptions.");
        }
    }

    private final class Client
    extends Thread {
        String url;
        final ConnectionFactory cf;
        public static final String SUBSCRIPTION_NAME = "subscription";
        private final int id;
        private final String conClientId;
        private final int lifetime = 60000;
        private final int online = 1000;
        private final int offline = 59000;
        private final ClientType clientType;
        private final String selector;

        public Client(int id, ClientType clientType) throws JMSException {
            super("Client" + id);
            this.url = "failover:(tcp://localhost:61656?wireFormat.maxInactivityDuration=0)?jms.watchTopicAdvisories=false&jms.alwaysSyncSend=true&jms.dispatchAsync=true&jms.producerWindowSize=20971520&jms.copyMessageOnSend=false&initialReconnectDelay=100&maxReconnectDelay=30000&useExponentialBackOff=true";
            this.cf = new ActiveMQConnectionFactory(this.url);
            this.lifetime = 60000;
            this.online = 1000;
            this.offline = 59000;
            this.setDaemon(true);
            this.id = id;
            this.conClientId = "cli" + id;
            this.clientType = clientType;
            this.selector = "(COMMIT = true and RELEVANT = true) or " + clientType.selector;
            this.subscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long end = System.currentTimeMillis() + 60000L;
            try {
                long max;
                boolean sleep = false;
                while ((max = end - System.currentTimeMillis()) > 0L) {
                    if (sleep) {
                        Thread.sleep(59000L);
                    } else {
                        sleep = true;
                    }
                    DurableSubDelayedUnsubscribeTest.this.processLock.readLock().lock();
                    try {
                        this.process(1000L);
                    }
                    finally {
                        DurableSubDelayedUnsubscribeTest.this.processLock.readLock().unlock();
                    }
                }
                if (!ALLOW_SUBSCRIPTION_ABANDONMENT) {
                    this.unsubscribe();
                    ALLOW_SUBSCRIPTION_ABANDONMENT = true;
                } else {
                    LOG.info("Client abandon the subscription. " + this);
                    ((DurableSubDelayedUnsubscribeTest)DurableSubDelayedUnsubscribeTest.this).houseKeeper.abandonedSubscriptions.add(this.conClientId);
                    ALLOW_SUBSCRIPTION_ABANDONMENT = false;
                }
            }
            catch (Throwable e) {
                DurableSubDelayedUnsubscribeTest.exit(this.toString() + " failed.", e);
            }
            DurableSubDelayedUnsubscribeTest.this.clientManager.removeClient(this);
            LOG.info(this.toString() + " DONE.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(long processingTime) throws JMSException {
            long end = System.currentTimeMillis() + processingTime;
            long hardEnd = end + 20000L;
            boolean inTransaction = false;
            int transCount = 0;
            LOG.info(this.toString() + " ONLINE.");
            Connection con = this.openConnection();
            Session sess = con.createSession(false, 2);
            TopicSubscriber consumer = sess.createDurableSubscriber((Topic)DurableSubDelayedUnsubscribeTest.this.topic, SUBSCRIPTION_NAME, this.selector, false);
            try {
                while (true) {
                    Message message;
                    long max;
                    if ((max = end - System.currentTimeMillis()) <= 0L) {
                        if (!inTransaction) {
                            break;
                        }
                        max = hardEnd - System.currentTimeMillis();
                        if (max <= 0L) {
                            DurableSubDelayedUnsubscribeTest.exit("" + this + " failed: Transaction is not finished.");
                        }
                    }
                    if ((message = consumer.receive(max)) == null) continue;
                    if (message.propertyExists("COMMIT")) {
                        message.acknowledge();
                        LOG.info("Received Trans[id=" + message.getIntProperty("TRANS") + ", count=" + transCount + "] in " + this + ".");
                        inTransaction = false;
                        transCount = 0;
                        continue;
                    }
                    inTransaction = true;
                    ++transCount;
                }
            }
            finally {
                sess.close();
                con.close();
                LOG.info(this.toString() + " OFFLINE.");
            }
        }

        private Connection openConnection() throws JMSException {
            Connection con = this.cf.createConnection();
            con.setClientID(this.conClientId);
            con.start();
            return con;
        }

        private void subscribe() throws JMSException {
            Connection con = this.openConnection();
            Session session = con.createSession(false, 1);
            session.createDurableSubscriber((Topic)DurableSubDelayedUnsubscribeTest.this.topic, SUBSCRIPTION_NAME, this.selector, true);
            session.close();
            con.close();
        }

        private void unsubscribe() throws JMSException {
            Connection con = this.openConnection();
            Session session = con.createSession(false, 1);
            session.unsubscribe(SUBSCRIPTION_NAME);
            session.close();
            con.close();
        }

        @Override
        public String toString() {
            return "Client[id=" + this.id + ", type=" + (Object)((Object)this.clientType) + "]";
        }
    }

    private final class ClientManager
    extends Thread {
        private int clientRover;
        private final CopyOnWriteArrayList<Client> clients;
        private boolean stopped;

        public ClientManager() {
            super("ClientManager");
            this.clientRover = 0;
            this.clients = new CopyOnWriteArrayList();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    if (this.clients.size() < 15) {
                        if (this.stopped) break;
                        DurableSubDelayedUnsubscribeTest.this.processLock.readLock().lock();
                        try {
                            this.createNewClient();
                        }
                        finally {
                            DurableSubDelayedUnsubscribeTest.this.processLock.readLock().unlock();
                        }
                    }
                    int size = this.clients.size();
                    DurableSubDelayedUnsubscribeTest.sleepRandom(size * 3 * 1000, size * 6 * 1000);
                }
            }
            catch (Throwable e) {
                DurableSubDelayedUnsubscribeTest.exit("ClientManager.run failed.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createNewClient() throws JMSException {
            Client client;
            ClientType type = ClientType.randomClientType();
            Object object = ((DurableSubDelayedUnsubscribeTest)DurableSubDelayedUnsubscribeTest.this).server.sendMutex;
            synchronized (object) {
                client = new Client(++this.clientRover, type);
                this.clients.add(client);
            }
            client.start();
            LOG.info(client.toString() + " created. " + this);
        }

        public void removeClient(Client client) {
            this.clients.remove(client);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ClientManager[count=");
            sb.append(this.clients.size());
            sb.append(", clients=");
            boolean sep = false;
            for (Client client : this.clients) {
                if (sep) {
                    sb.append(", ");
                } else {
                    sep = true;
                }
                sb.append(client.toString());
            }
            sb.append(']');
            return sb.toString();
        }
    }

    private static enum ClientType {
        A("a", "b", "c"),
        B("c", "d", "e"),
        C("d", "e", "f"),
        D("g", "h");

        public final String[] messageTypes;
        public final String selector;

        private ClientType(String ... messageTypes) {
            this.messageTypes = messageTypes;
            StringBuilder sb = new StringBuilder("TYPE in (");
            for (int i = 0; i < messageTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append('\'').append(messageTypes[i]).append('\'');
            }
            sb.append(')');
            this.selector = sb.toString();
        }

        public static ClientType randomClientType() {
            return ClientType.values()[DurableSubDelayedUnsubscribeTest.random(ClientType.values().length - 1)];
        }

        public final String randomMessageType() {
            return this.messageTypes[DurableSubDelayedUnsubscribeTest.random(this.messageTypes.length - 1)];
        }

        public static String randomNonRelevantMessageType() {
            return Integer.toString(DurableSubDelayedUnsubscribeTest.random(20));
        }

        public final String toString() {
            return this.name();
        }
    }

    final class Server
    extends Thread {
        public boolean stopped;
        final String url;
        final ConnectionFactory cf;
        final Object sendMutex;
        final String[] cargos;
        int transRover;
        int messageRover;

        public Server() {
            super("Server");
            this.url = "vm://" + DurableSubDelayedUnsubscribeTest.getName() + "?" + "jms.redeliveryPolicy.maximumRedeliveries=2&jms.redeliveryPolicy.initialRedeliveryDelay=500&" + "jms.producerWindowSize=20971520&jms.prefetchPolicy.all=100&" + "jms.copyMessageOnSend=false&jms.disableTimeStampsByDefault=false&" + "jms.alwaysSyncSend=true&jms.dispatchAsync=false&" + "jms.watchTopicAdvisories=false&" + "waitForStart=200&create=false";
            this.cf = new ActiveMQConnectionFactory(this.url);
            this.sendMutex = new Object();
            this.cargos = new String[500];
            this.transRover = 0;
            this.messageRover = 0;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.stopped) {
                    Thread.sleep(500L);
                    DurableSubDelayedUnsubscribeTest.this.processLock.readLock().lock();
                    try {
                        this.send();
                    }
                    finally {
                        DurableSubDelayedUnsubscribeTest.this.processLock.readLock().unlock();
                    }
                }
            }
            catch (Throwable e) {
                DurableSubDelayedUnsubscribeTest.exit("Server.run failed", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send() throws JMSException {
            Object object = this.sendMutex;
            synchronized (object) {
                int trans = ++this.transRover;
                boolean relevantTrans = DurableSubDelayedUnsubscribeTest.random(2) > 1;
                ClientType clientType = relevantTrans ? ClientType.randomClientType() : null;
                int count = DurableSubDelayedUnsubscribeTest.random(200);
                LOG.info("Sending Trans[id=" + trans + ", count=" + count + ", clientType=" + (Object)((Object)clientType) + "]");
                Connection con = this.cf.createConnection();
                Session sess = con.createSession(true, 0);
                MessageProducer prod = sess.createProducer(null);
                for (int i = 0; i < count; ++i) {
                    Message message = sess.createMessage();
                    message.setIntProperty("ID", ++this.messageRover);
                    message.setIntProperty("TRANS", trans);
                    String type = clientType != null ? clientType.randomMessageType() : ClientType.randomNonRelevantMessageType();
                    message.setStringProperty("TYPE", type);
                    message.setStringProperty("CARGO", this.getCargo(DurableSubDelayedUnsubscribeTest.random(400)));
                    prod.send((Destination)DurableSubDelayedUnsubscribeTest.this.topic, message);
                }
                Message message = sess.createMessage();
                message.setIntProperty("ID", ++this.messageRover);
                message.setIntProperty("TRANS", trans);
                message.setBooleanProperty("COMMIT", true);
                message.setBooleanProperty("RELEVANT", relevantTrans);
                prod.send((Destination)DurableSubDelayedUnsubscribeTest.this.topic, message);
                sess.commit();
                LOG.info("Committed Trans[id=" + trans + ", count=" + count + ", clientType=" + (Object)((Object)clientType) + "], ID=" + this.messageRover);
                sess.close();
                con.close();
            }
        }

        private String getCargo(int length) {
            if (length == 0) {
                return null;
            }
            if (length < this.cargos.length) {
                String result = this.cargos[length];
                if (result == null) {
                    this.cargos[length] = result = this.getCargoImpl(length);
                }
                return result;
            }
            return this.getCargoImpl(length);
        }

        private String getCargoImpl(int length) {
            StringBuilder sb = new StringBuilder(length);
            int i = length;
            while (--i >= 0) {
                sb.append('a');
            }
            return sb.toString();
        }
    }
}

