/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.leveldb.LevelDBStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiredMessagesTest
extends CombinationTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ExpiredMessagesTest.class);
    BrokerService broker;
    Connection connection;
    Session session;
    MessageProducer producer;
    MessageConsumer consumer;
    public ActiveMQDestination destination = new ActiveMQQueue("test");
    public ActiveMQDestination dlqDestination = new ActiveMQQueue("ActiveMQ.DLQ");
    public boolean useTextMessage = true;
    public boolean useVMCursor = true;
    protected String brokerUri;

    public static Test suite() {
        return ExpiredMessagesTest.suite(ExpiredMessagesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ExpiredMessagesTest.suite());
    }

    protected void setUp() throws Exception {
        boolean deleteAllMessages = true;
        this.broker = this.createBroker(true, 100L);
        this.brokerUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    public void testExpiredMessages() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerUri);
        this.connection = factory.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.producer = this.session.createProducer((Destination)this.destination);
        this.producer.setTimeToLive(100L);
        this.consumer = this.session.createConsumer((Destination)this.destination);
        this.connection.start();
        final AtomicLong received = new AtomicLong();
        Thread consumerThread2 = new Thread("Consumer Thread"){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    long end = System.currentTimeMillis();
                    while (end - start < 3000L) {
                        if (ExpiredMessagesTest.this.consumer.receive(1000L) != null) {
                            received.incrementAndGet();
                        }
                        Thread.sleep(100L);
                        end = System.currentTimeMillis();
                    }
                    ExpiredMessagesTest.this.consumer.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        consumerThread2.start();
        int numMessagesToSend = 10000;
        Thread producingThread = new Thread("Producing Thread"){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i++ < 10000) {
                        ExpiredMessagesTest.this.producer.send((Message)ExpiredMessagesTest.this.session.createTextMessage("test"));
                    }
                    ExpiredMessagesTest.this.producer.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        producingThread.start();
        consumerThread2.join();
        producingThread.join();
        this.session.close();
        final DestinationStatistics view = TestSupport.getDestinationStatistics(this.broker, this.destination);
        ExpiredMessagesTest.assertTrue((String)"all inflight messages expired ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return view.getInflight().getCount() == 0L;
            }
        }));
        ExpiredMessagesTest.assertEquals((String)"Wrong inFlightCount: ", (long)0L, (long)view.getInflight().getCount());
        LOG.info("Stats: received: " + received.get() + ", enqueues: " + view.getEnqueues().getCount() + ", dequeues: " + view.getDequeues().getCount() + ", dispatched: " + view.getDispatched().getCount() + ", inflight: " + view.getInflight().getCount() + ", expiries: " + view.getExpired().getCount());
        ExpiredMessagesTest.assertTrue((String)"all sent messages expired ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                long oldEnqueues = view.getEnqueues().getCount();
                Thread.sleep(200L);
                LOG.info("Stats: received: " + received.get() + ", size= " + view.getMessages().getCount() + ", enqueues: " + view.getDequeues().getCount() + ", dequeues: " + view.getDequeues().getCount() + ", dispatched: " + view.getDispatched().getCount() + ", inflight: " + view.getInflight().getCount() + ", expiries: " + view.getExpired().getCount());
                return oldEnqueues == view.getEnqueues().getCount();
            }
        }, (long)60000L));
        LOG.info("Stats: received: " + received.get() + ", size= " + view.getMessages().getCount() + ", enqueues: " + view.getEnqueues().getCount() + ", dequeues: " + view.getDequeues().getCount() + ", dispatched: " + view.getDispatched().getCount() + ", inflight: " + view.getInflight().getCount() + ", expiries: " + view.getExpired().getCount());
        ExpiredMessagesTest.assertTrue((String)"got at least what did not expire", (received.get() >= view.getDequeues().getCount() - view.getExpired().getCount() ? 1 : 0) != 0);
        ExpiredMessagesTest.assertTrue((String)("all messages expired - queue size gone to zero " + view.getMessages().getCount()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("Stats: received: " + received.get() + ", size= " + view.getMessages().getCount() + ", enqueues: " + view.getEnqueues().getCount() + ", dequeues: " + view.getDequeues().getCount() + ", dispatched: " + view.getDispatched().getCount() + ", inflight: " + view.getInflight().getCount() + ", expiries: " + view.getExpired().getCount());
                return view.getMessages().getCount() == 0L;
            }
        }));
        long expiredBeforeEnqueue = 10000L - view.getEnqueues().getCount();
        final long totalExpiredCount = view.getExpired().getCount() + expiredBeforeEnqueue;
        final DestinationStatistics dlqView = TestSupport.getDestinationStatistics(this.broker, this.dlqDestination);
        LOG.info("DLQ stats: size= " + dlqView.getMessages().getCount() + ", enqueues: " + dlqView.getDequeues().getCount() + ", dequeues: " + dlqView.getDequeues().getCount() + ", dispatched: " + dlqView.getDispatched().getCount() + ", inflight: " + dlqView.getInflight().getCount() + ", expiries: " + dlqView.getExpired().getCount());
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return totalExpiredCount == dlqView.getMessages().getCount();
            }
        });
        ExpiredMessagesTest.assertEquals((String)"dlq contains all expired", (long)totalExpiredCount, (long)dlqView.getMessages().getCount());
        ExpiredMessagesTest.assertEquals((String)"memory usage is back to duck egg", (int)0, (int)TestSupport.getDestination(this.broker, this.destination).getMemoryUsage().getPercentUsage());
        ExpiredMessagesTest.assertTrue((String)"memory usage is increased ", (0 < TestSupport.getDestination(this.broker, this.dlqDestination).getMemoryUsage().getPercentUsage() ? 1 : 0) != 0);
        MessageConsumer dlqConsumer = this.createDlqConsumer(this.connection);
        final DLQListener dlqListener = new DLQListener();
        dlqConsumer.setMessageListener((MessageListener)dlqListener);
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return totalExpiredCount == (long)dlqListener.count;
            }
        }, (long)60000L);
        ExpiredMessagesTest.assertEquals((String)"dlq returned all expired", (long)dlqListener.count, (long)totalExpiredCount);
    }

    private MessageConsumer createDlqConsumer(Connection connection) throws Exception {
        return connection.createSession(false, 1).createConsumer((Destination)this.dlqDestination);
    }

    public void initCombosForTestRecoverExpiredMessages() {
        this.addCombinationValues("useVMCursor", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testRecoverExpiredMessages() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("failover://" + this.brokerUri);
        this.connection = factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.producer = this.session.createProducer((Destination)this.destination);
        this.producer.setTimeToLive(2000L);
        this.producer.setDeliveryMode(2);
        Thread producingThread = new Thread("Producing Thread"){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i++ < 1000) {
                        TextMessage message = ExpiredMessagesTest.this.useTextMessage ? ExpiredMessagesTest.this.session.createTextMessage("test") : ExpiredMessagesTest.this.session.createObjectMessage((Serializable)((Object)"test"));
                        ExpiredMessagesTest.this.producer.send((Message)message);
                    }
                    ExpiredMessagesTest.this.producer.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        producingThread.start();
        producingThread.join();
        DestinationStatistics view = TestSupport.getDestinationStatistics(this.broker, this.destination);
        LOG.info("Stats: size: " + view.getMessages().getCount() + ", enqueues: " + view.getEnqueues().getCount() + ", dequeues: " + view.getDequeues().getCount() + ", dispatched: " + view.getDispatched().getCount() + ", inflight: " + view.getInflight().getCount() + ", expiries: " + view.getExpired().getCount());
        LOG.info("stopping broker");
        this.broker.stop();
        this.broker.waitUntilStopped();
        Thread.sleep(5000L);
        LOG.info("recovering broker");
        boolean deleteAllMessages = false;
        this.broker = this.createBroker(false, 5000L);
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                DestinationStatistics view = TestSupport.getDestinationStatistics(ExpiredMessagesTest.this.broker, ExpiredMessagesTest.this.destination);
                LOG.info("Stats: size: " + view.getMessages().getCount() + ", enqueues: " + view.getEnqueues().getCount() + ", dequeues: " + view.getDequeues().getCount() + ", dispatched: " + view.getDispatched().getCount() + ", inflight: " + view.getInflight().getCount() + ", expiries: " + view.getExpired().getCount());
                return view.getMessages().getCount() == 0L;
            }
        });
        view = TestSupport.getDestinationStatistics(this.broker, this.destination);
        ExpiredMessagesTest.assertEquals((String)"Expect empty queue, QueueSize: ", (long)0L, (long)view.getMessages().getCount());
        ExpiredMessagesTest.assertEquals((String)"all dequeues were expired", (long)view.getDequeues().getCount(), (long)view.getExpired().getCount());
    }

    private BrokerService createBroker(boolean deleteAllMessages, long expireMessagesPeriod) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("localhost");
        broker.setDestinations(new ActiveMQDestination[]{this.destination});
        LevelDBStore adaptor = new LevelDBStore();
        adaptor.setDirectory(new File("target/expiredtest-data/"));
        broker.setPersistenceAdapter((PersistenceAdapter)adaptor);
        PolicyEntry defaultPolicy = new PolicyEntry();
        if (this.useVMCursor) {
            defaultPolicy.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        }
        defaultPolicy.setExpireMessagesPeriod(expireMessagesPeriod);
        defaultPolicy.setMaxExpirePageSize(1200);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(defaultPolicy);
        broker.setDestinationPolicy(policyMap);
        broker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        broker.addConnector("tcp://localhost:0");
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }

    protected void tearDown() throws Exception {
        this.connection.stop();
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    class DLQListener
    implements MessageListener {
        int count = 0;

        DLQListener() {
        }

        public void onMessage(Message message) {
            ++this.count;
        }
    }
}

