/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.RedeliveryPolicyMap;
import org.apache.activemq.broker.util.RedeliveryPlugin;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerRedeliveryTest
extends TestSupport {
    static final Logger LOG = LoggerFactory.getLogger(BrokerRedeliveryTest.class);
    BrokerService broker = null;
    final ActiveMQQueue destination = new ActiveMQQueue("Redelivery");
    final String data = "hi";
    final long redeliveryDelayMillis = 2000L;
    final long initialRedeliveryDelayMillis = 4000L;
    int maxBrokerRedeliveries = 2;

    public void testScheduledRedelivery() throws Exception {
        this.doTestScheduledRedelivery(this.maxBrokerRedeliveries, true);
    }

    public void testInfiniteRedelivery() throws Exception {
        this.maxBrokerRedeliveries = -1;
        this.doTestScheduledRedelivery(7, false);
    }

    public void doTestScheduledRedelivery(int maxBrokerRedeliveriesToValidate, boolean validateDLQ) throws Exception {
        this.startBroker(true);
        this.sendMessage(0);
        ActiveMQConnection consumerConnection = (ActiveMQConnection)this.createConnection();
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setInitialRedeliveryDelay(0L);
        redeliveryPolicy.setMaximumRedeliveries(0);
        consumerConnection.setRedeliveryPolicy(redeliveryPolicy);
        consumerConnection.start();
        Session consumerSession = consumerConnection.createSession(true, 0);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)this.destination);
        Message message = consumer.receive(1000L);
        BrokerRedeliveryTest.assertNotNull((String)"got message", (Object)message);
        LOG.info("got: " + message);
        consumerSession.rollback();
        for (int i = 0; i < maxBrokerRedeliveriesToValidate; ++i) {
            Message shouldBeNull = consumer.receive(500L);
            BrokerRedeliveryTest.assertNull((String)("did not get message after redelivery count exceeded: " + shouldBeNull), (Object)shouldBeNull);
            TimeUnit.SECONDS.sleep(3L);
            Message brokerRedeliveryMessage = consumer.receive(500L);
            LOG.info("got: " + brokerRedeliveryMessage);
            BrokerRedeliveryTest.assertNotNull((String)"got message via broker redelivery after delay", (Object)brokerRedeliveryMessage);
            BrokerRedeliveryTest.assertEquals((String)"message matches", (String)message.getStringProperty("data"), (String)brokerRedeliveryMessage.getStringProperty("data"));
            BrokerRedeliveryTest.assertEquals((String)"has expiryDelay specified", (long)(i == 0 ? 4000L : 2000L), (long)brokerRedeliveryMessage.getLongProperty("redeliveryDelay"));
            consumerSession.rollback();
        }
        if (validateDLQ) {
            MessageConsumer dlqConsumer = consumerSession.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
            Message dlqMessage = dlqConsumer.receive(2000L);
            BrokerRedeliveryTest.assertNotNull((String)"Got message from dql", (Object)dlqMessage);
            BrokerRedeliveryTest.assertEquals((String)"message matches", (String)message.getStringProperty("data"), (String)dlqMessage.getStringProperty("data"));
            consumerSession.commit();
        } else {
            message = consumer.receive(3000L);
            BrokerRedeliveryTest.assertNotNull((String)"got message", (Object)message);
            BrokerRedeliveryTest.assertEquals((String)"redeliveries accounted for", (long)(maxBrokerRedeliveriesToValidate + 2), (long)message.getLongProperty("JMSXDeliveryCount"));
            consumerSession.commit();
        }
        consumerConnection.close();
    }

    public void testNoScheduledRedeliveryOfExpired() throws Exception {
        this.startBroker(true);
        ActiveMQConnection consumerConnection = (ActiveMQConnection)this.createConnection();
        consumerConnection.start();
        Session consumerSession = consumerConnection.createSession(false, 2);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)this.destination);
        this.sendMessage(1000);
        Message message = consumer.receive(1000L);
        BrokerRedeliveryTest.assertNotNull((String)"got message", (Object)message);
        MessageConsumer redeliverConsumer = consumerSession.createConsumer((Destination)this.destination);
        TimeUnit.SECONDS.sleep(2L);
        consumer.close();
        MessageConsumer dlqConsumer = consumerSession.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        Message dlqMessage = dlqConsumer.receive(2000L);
        BrokerRedeliveryTest.assertNotNull((String)"Got message from dql", (Object)dlqMessage);
        BrokerRedeliveryTest.assertEquals((String)"message matches", (String)message.getStringProperty("data"), (String)dlqMessage.getStringProperty("data"));
    }

    private void sendMessage(int timeToLive) throws Exception {
        ActiveMQConnection producerConnection = (ActiveMQConnection)this.createConnection();
        producerConnection.start();
        Session producerSession = producerConnection.createSession(false, 1);
        MessageProducer producer = producerSession.createProducer((Destination)this.destination);
        if (timeToLive > 0) {
            producer.setTimeToLive((long)timeToLive);
        }
        Message message = producerSession.createMessage();
        message.setStringProperty("data", "hi");
        producer.send(message);
        producerConnection.close();
    }

    private void startBroker(boolean deleteMessages) throws Exception {
        this.broker = new BrokerService();
        this.broker.setSchedulerSupport(true);
        RedeliveryPlugin redeliveryPlugin = new RedeliveryPlugin();
        RedeliveryPolicy brokerRedeliveryPolicy = new RedeliveryPolicy();
        brokerRedeliveryPolicy.setRedeliveryDelay(2000L);
        brokerRedeliveryPolicy.setInitialRedeliveryDelay(4000L);
        brokerRedeliveryPolicy.setMaximumRedeliveries(this.maxBrokerRedeliveries);
        RedeliveryPolicyMap redeliveryPolicyMap = new RedeliveryPolicyMap();
        redeliveryPolicyMap.setDefaultEntry(brokerRedeliveryPolicy);
        redeliveryPlugin.setRedeliveryPolicyMap(redeliveryPolicyMap);
        this.broker.setPlugins(new BrokerPlugin[]{redeliveryPlugin});
        if (deleteMessages) {
            this.broker.setDeleteAllMessagesOnStartup(true);
        }
        this.broker.start();
    }

    private void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
        this.broker = null;
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost");
    }

    protected void tearDown() throws Exception {
        this.stopBroker();
        super.tearDown();
    }
}

