/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;

public class BrokerTest
extends BrokerTestSupport {
    public ActiveMQDestination destination;
    public int deliveryMode;
    public int prefetch;
    public byte destinationType;
    public boolean durableConsumer;
    protected static final int MAX_NULL_WAIT = 500;

    public void initCombosForTestQueueOnlyOnceDeliveryWith2Consumers() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
    }

    public void testQueueOnlyOnceDeliveryWith2Consumers() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(1);
        connection1.request((Command)consumerInfo1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setPrefetchSize(1);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.request((Command)consumerInfo2);
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.request((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        for (int i = 0; i < 2; ++i) {
            Message m1 = this.receiveMessage(connection1);
            Message m2 = this.receiveMessage(connection2);
            BrokerTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            BrokerTest.assertNotNull((String)("m2 is null for index: " + i), (Object)m2);
            BrokerTest.assertNotSame((Object)m1.getMessageId(), (Object)m2.getMessageId());
            connection1.send((Command)this.createAck(consumerInfo1, m1, 1, (byte)2));
            connection2.send((Command)this.createAck(consumerInfo2, m2, 1, (byte)2));
        }
        this.assertNoMessagesLeft(connection1);
        this.assertNoMessagesLeft(connection2);
    }

    public void initCombosForTestQueueBrowserWith2Consumers() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
    }

    public void testQueueBrowserWith2Consumers() throws Exception {
        Message m1;
        int i;
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(10);
        connection1.request((Command)consumerInfo1);
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.request((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setPrefetchSize(1);
        consumerInfo2.setBrowser(true);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.request((Command)consumerInfo2);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (i = 0; i < 4; ++i) {
            m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            messages.add(m1);
        }
        for (i = 0; i < 4; ++i) {
            m1 = (Message)messages.get(i);
            Message m2 = this.receiveMessage(connection2);
            BrokerTest.assertNotNull((String)("m2 is null for index: " + i), (Object)m2);
            BrokerTest.assertEquals((Object)m1.getMessageId(), (Object)m2.getMessageId());
            connection2.send((Command)this.createAck(consumerInfo2, m2, 1, (byte)0));
        }
        this.assertNoMessagesLeft(connection1);
        this.assertNoMessagesLeft(connection2);
    }

    public void testQueueBrowserWith2ConsumersBrowseFirst() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.deliveryMode = 1;
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setPrefetchSize(10);
        consumerInfo2.setBrowser(true);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.request((Command)consumerInfo2);
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(10);
        connection1.request((Command)consumerInfo1);
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.request((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        ArrayList<Message> messages = new ArrayList<Message>();
        for (int i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            messages.add(m1);
        }
        this.assertNoMessagesLeft(connection1);
        this.assertNoMessagesLeft(connection2);
    }

    public void testQueueBrowserWith2ConsumersInterleaved() throws Exception {
        Message m1;
        int i;
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.deliveryMode = 1;
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(10);
        connection1.request((Command)consumerInfo1);
        connection1.request((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setPrefetchSize(1);
        consumerInfo2.setBrowser(true);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.request((Command)consumerInfo2);
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.request((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        ArrayList<Message> messages = new ArrayList<Message>();
        for (i = 0; i < 4; ++i) {
            m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            messages.add(m1);
        }
        for (i = 0; i < 4; ++i) {
            m1 = (Message)messages.get(i);
            Message m2 = this.receiveMessage(connection2);
            BrokerTest.assertNotNull((String)("m2 is null for index: " + i), (Object)m2);
            BrokerTest.assertEquals((Object)m1.getMessageId(), (Object)m2.getMessageId());
            connection2.send((Command)this.createAck(consumerInfo2, m2, 1, (byte)0));
        }
        this.assertNoMessagesLeft(connection1);
        this.assertNoMessagesLeft(connection2);
    }

    public void initCombosForTestConsumerPrefetchAndStandardAck() {
        this.addCombinationValues("deliveryMode", new Object[]{2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testConsumerPrefetchAndStandardAck() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        consumerInfo.setPrefetchSize(1);
        connection.send((Command)consumerInfo);
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection.request((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        Message m1 = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m1);
        this.assertNoMessagesLeft(connection);
        connection.send((Command)this.createAck(consumerInfo, m1, 1, (byte)2));
        Message m2 = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m2);
        connection.send((Command)this.createAck(consumerInfo, m2, 1, (byte)2));
        Message m3 = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m3);
        connection.send((Command)this.createAck(consumerInfo, m3, 1, (byte)2));
        connection.send((Command)this.closeConnectionInfo(connectionInfo));
    }

    public void initCombosForTestTransactedAckWithPrefetchOfOne() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testTransactedAckWithPrefetchOfOne() throws Exception {
        int i;
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        consumerInfo1.setPrefetchSize(1);
        connection1.send((Command)consumerInfo1);
        for (i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo1, this.destination, this.deliveryMode);
            connection1.send((Command)message);
        }
        for (i = 0; i < 4; ++i) {
            LocalTransactionId txid = this.createLocalTransaction(sessionInfo1);
            connection1.send((Command)this.createBeginTransaction(connectionInfo1, (TransactionId)txid));
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m1);
            MessageAck ack = this.createAck(consumerInfo1, m1, 1, (byte)2);
            ack.setTransactionId((TransactionId)txid);
            connection1.send((Command)ack);
            connection1.send((Command)this.createCommitTransaction1Phase(connectionInfo1, (TransactionId)txid));
        }
        this.assertNoMessagesLeft(connection1);
    }

    public void initCombosForTestTransactedSend() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testTransactedSend() throws Exception {
        int i;
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo1);
        connection1.send((Command)this.createBeginTransaction(connectionInfo1, (TransactionId)txid));
        for (i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo1, this.destination, this.deliveryMode);
            message.setTransactionId((TransactionId)txid);
            connection1.request((Command)message);
        }
        BrokerTest.assertNull((Object)this.receiveMessage(connection1, 500L));
        connection1.send((Command)this.createCommitTransaction1Phase(connectionInfo1, (TransactionId)txid));
        for (i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m1);
        }
        this.assertNoMessagesLeft(connection1);
    }

    public void initCombosForTestQueueTransactedAck() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)5});
    }

    public void testQueueTransactedAck() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo1, this.destination, this.deliveryMode);
            connection1.send((Command)message);
        }
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo1);
        connection1.send((Command)this.createBeginTransaction(connectionInfo1, (TransactionId)txid));
        for (int i = 0; i < 2; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            MessageAck ack = this.createAck(consumerInfo1, m1, 1, (byte)2);
            ack.setTransactionId((TransactionId)txid);
            connection1.request((Command)ack);
        }
        connection1.send((Command)this.createCommitTransaction1Phase(connectionInfo1, (TransactionId)txid));
        BrokerTest.assertEquals((int)2, (int)this.countMessagesInQueue(connection1, connectionInfo1, this.destination));
    }

    public void initCombosForTestConsumerCloseCausesRedelivery() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST")});
    }

    public void testConsumerCloseCausesRedelivery() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        consumerInfo1.setPrefetchSize(100);
        connection1.request((Command)consumerInfo1);
        connection1.send((Command)this.createMessage(producerInfo1, this.destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, this.destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, this.destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, this.destination, this.deliveryMode));
        for (int i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            BrokerTest.assertFalse((boolean)m1.isRedelivered());
        }
        connection1.send((Command)consumerInfo1.createRemoveCommand());
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo1, this.destination);
        consumerInfo2.setPrefetchSize(100);
        connection1.request((Command)consumerInfo2);
        for (int i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            BrokerTest.assertTrue((boolean)m1.isRedelivered());
        }
        this.assertNoMessagesLeft(connection1);
    }

    public void testTopicDurableSubscriptionCanBeRestored() throws Exception {
        ActiveMQTopic destination = new ActiveMQTopic("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        connectionInfo1.setClientId("clientid1");
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(100);
        consumerInfo1.setSubscriptionName("test");
        connection1.send((Command)consumerInfo1);
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, 2));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, 2));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, 2));
        connection1.request((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, 2));
        Message m = null;
        for (int i = 0; i < 2; ++i) {
            m = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m);
        }
        connection1.send((Command)this.createAck(consumerInfo1, m, 2, (byte)2));
        connection1.request((Command)this.closeConnectionInfo(connectionInfo1));
        connection1.stop();
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        connectionInfo2.setClientId("clientid1");
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setPrefetchSize(100);
        consumerInfo2.setSubscriptionName("test");
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)consumerInfo2);
        for (int i = 0; i < 2; ++i) {
            Message m1 = this.receiveMessage(connection2);
            BrokerTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
        }
        this.assertNoMessagesLeft(connection2);
    }

    public void initCombosForTestGroupedMessagesDeliveredToOnlyOneConsumer() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
    }

    public void testGroupedMessagesDeliveredToOnlyOneConsumer() throws Exception {
        Message m1;
        int i;
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(1);
        connection1.send((Command)consumerInfo1);
        for (int i2 = 0; i2 < 4; ++i2) {
            Message message = this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode);
            message.setGroupID("TEST-GROUP");
            message.setGroupSequence(i2 + 1);
            connection1.request((Command)message);
        }
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setPrefetchSize(1);
        connection2.send((Command)consumerInfo2);
        for (i = 0; i < 3; ++i) {
            m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            connection1.send((Command)this.createAck(consumerInfo1, m1, 1, (byte)2));
        }
        connection1.request((Command)this.closeConsumerInfo(consumerInfo1));
        for (i = 0; i < 1; ++i) {
            m1 = this.receiveMessage(connection2);
            BrokerTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            connection2.request((Command)this.createAck(consumerInfo2, m1, 1, (byte)2));
        }
        this.assertNoMessagesLeft(connection2);
    }

    public void initCombosForTestTopicConsumerOnlySeeMessagesAfterCreation() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("durableConsumer", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testTopicConsumerOnlySeeMessagesAfterCreation() throws Exception {
        ActiveMQTopic destination = new ActiveMQTopic("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        connectionInfo1.setClientId("A");
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        if (this.durableConsumer) {
            consumerInfo1.setSubscriptionName("test");
        }
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        Message m = this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode);
        connection1.send((Command)m);
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        Message m2 = this.receiveMessage(connection1);
        BrokerTest.assertNotNull((Object)m2);
        BrokerTest.assertEquals((Object)m.getMessageId(), (Object)m2.getMessageId());
        m2 = this.receiveMessage(connection1);
        BrokerTest.assertNotNull((Object)m2);
        this.assertNoMessagesLeft(connection1);
    }

    public void initCombosForTestTopicRetroactiveConsumerSeeMessagesBeforeCreation() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("durableConsumer", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testTopicRetroactiveConsumerSeeMessagesBeforeCreation() throws Exception {
        ActiveMQTopic destination = new ActiveMQTopic("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        connectionInfo1.setClientId("A");
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        Message m = this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode);
        connection1.send((Command)m);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        if (this.durableConsumer) {
            consumerInfo1.setSubscriptionName("test");
        }
        consumerInfo1.setPrefetchSize(100);
        consumerInfo1.setRetroactive(true);
        connection1.send((Command)consumerInfo1);
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.request((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        Message m2 = this.receiveMessage(connection1);
        BrokerTest.assertNotNull((Object)m2);
        BrokerTest.assertEquals((Object)m.getMessageId(), (Object)m2.getMessageId());
        for (int i = 0; i < 2; ++i) {
            m2 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m2);
        }
        this.assertNoMessagesLeft(connection1);
    }

    public void initCombosForTestExclusiveQueueDeliversToOnlyOneConsumer() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
    }

    public void testExclusiveQueueDeliversToOnlyOneConsumer() throws Exception {
        Message m1;
        int i;
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(1);
        consumerInfo1.setExclusive(true);
        connection1.send((Command)consumerInfo1);
        connection1.request((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setPrefetchSize(1);
        consumerInfo2.setExclusive(true);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.request((Command)consumerInfo2);
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        for (i = 0; i < 2; ++i) {
            m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m1);
            connection1.send((Command)this.createAck(consumerInfo1, m1, 1, (byte)2));
        }
        connection1.send((Command)this.closeConsumerInfo(consumerInfo1));
        connection1.send((Command)this.createMessage(producerInfo, (ActiveMQDestination)destination, this.deliveryMode));
        for (i = 0; i < 2; ++i) {
            m1 = this.receiveMessage(connection2);
            BrokerTest.assertNotNull((Object)m1);
            connection2.send((Command)this.createAck(consumerInfo2, m1, 1, (byte)2));
        }
        this.assertNoMessagesLeft(connection2);
    }

    public void initCombosForTestWildcardConsume() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2});
    }

    public void testWildcardConsume() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ActiveMQDestination compositeDestination = ActiveMQDestination.createDestination((String)"WILD.*.TEST", (byte)this.destinationType);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, compositeDestination);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        connection1.send((Command)this.createMessage(producerInfo1, ActiveMQDestination.createDestination((String)"WILD.CARD", (byte)this.destinationType), this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, ActiveMQDestination.createDestination((String)"WILD.TEST", (byte)this.destinationType), this.deliveryMode));
        ActiveMQDestination d1 = ActiveMQDestination.createDestination((String)"WILD.CARD.TEST", (byte)this.destinationType);
        connection1.send((Command)this.createMessage(producerInfo1, d1, this.deliveryMode));
        Message m = this.receiveMessage(connection1);
        BrokerTest.assertNotNull((Object)m);
        BrokerTest.assertEquals((Object)d1, (Object)m.getDestination());
        ActiveMQDestination d2 = ActiveMQDestination.createDestination((String)"WILD.FOO.TEST", (byte)this.destinationType);
        connection1.request((Command)this.createMessage(producerInfo1, d2, this.deliveryMode));
        m = this.receiveMessage(connection1);
        BrokerTest.assertNotNull((Object)m);
        BrokerTest.assertEquals((Object)d2, (Object)m.getDestination());
        this.assertNoMessagesLeft(connection1);
        connection1.send((Command)this.closeConnectionInfo(connectionInfo1));
    }

    public void initCombosForTestCompositeConsume() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2});
    }

    public void testCompositeConsume() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ActiveMQDestination compositeDestination = ActiveMQDestination.createDestination((String)"A,B", (byte)this.destinationType);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, compositeDestination);
        consumerInfo1.setRetroactive(true);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        ActiveMQDestination destinationA = ActiveMQDestination.createDestination((String)"A", (byte)this.destinationType);
        ActiveMQDestination destinationB = ActiveMQDestination.createDestination((String)"B", (byte)this.destinationType);
        connection1.send((Command)this.createMessage(producerInfo1, destinationA, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, destinationB, this.deliveryMode));
        for (int i = 0; i < 2; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m1);
        }
        this.assertNoMessagesLeft(connection1);
        connection1.send((Command)this.closeConnectionInfo(connectionInfo1));
    }

    public void initCombosForTestCompositeSend() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2});
    }

    public void testCompositeSend() throws Exception {
        int i;
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ActiveMQDestination destinationA = ActiveMQDestination.createDestination((String)"A", (byte)this.destinationType);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, destinationA);
        consumerInfo1.setRetroactive(true);
        consumerInfo1.setPrefetchSize(100);
        connection1.request((Command)consumerInfo1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        ActiveMQDestination destinationB = ActiveMQDestination.createDestination((String)"B", (byte)this.destinationType);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, destinationB);
        consumerInfo2.setRetroactive(true);
        consumerInfo2.setPrefetchSize(100);
        connection2.request((Command)consumerInfo2);
        ActiveMQDestination compositeDestination = ActiveMQDestination.createDestination((String)"A,B", (byte)this.destinationType);
        for (i = 0; i < 4; ++i) {
            connection1.request((Command)this.createMessage(producerInfo1, compositeDestination, this.deliveryMode));
        }
        for (i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            Message m2 = this.receiveMessage(connection2);
            BrokerTest.assertNotNull((Object)m1);
            BrokerTest.assertNotNull((Object)m2);
            BrokerTest.assertEquals((Object)m1.getMessageId(), (Object)m2.getMessageId());
            BrokerTest.assertEquals((Object)compositeDestination, (Object)m1.getOriginalDestination());
            BrokerTest.assertEquals((Object)compositeDestination, (Object)m2.getOriginalDestination());
            connection1.request((Command)this.createAck(consumerInfo1, m1, 1, (byte)2));
            connection2.request((Command)this.createAck(consumerInfo2, m2, 1, (byte)2));
        }
        this.assertNoMessagesLeft(connection1);
        this.assertNoMessagesLeft(connection2);
        connection1.send((Command)this.closeConnectionInfo(connectionInfo1));
        connection2.send((Command)this.closeConnectionInfo(connectionInfo2));
    }

    public void initCombosForTestConnectionCloseCascades() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destination", new Object[]{new ActiveMQTopic("TEST"), new ActiveMQQueue("TEST")});
    }

    public void testConnectionCloseCascades() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        consumerInfo1.setPrefetchSize(100);
        consumerInfo1.setNoLocal(true);
        connection1.request((Command)consumerInfo1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ProducerInfo producerInfo2 = this.createProducerInfo(sessionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)producerInfo2);
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        for (int i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m1);
            connection1.send((Command)this.createAck(consumerInfo1, m1, 1, (byte)2));
        }
        Message msg = this.receiveMessage(connection1, 500L);
        BrokerTest.assertNull((String)("all messages were received " + msg), (Object)msg);
        connection1.request((Command)this.closeConnectionInfo(connectionInfo1));
        connection2.request((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        BrokerTest.assertNull((String)"no message received", (Object)this.receiveMessage(connection1, 500L));
    }

    public void initCombosForTestSessionCloseCascades() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destination", new Object[]{new ActiveMQTopic("TEST"), new ActiveMQQueue("TEST")});
    }

    public void testSessionCloseCascades() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        consumerInfo1.setPrefetchSize(100);
        consumerInfo1.setNoLocal(true);
        connection1.request((Command)consumerInfo1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ProducerInfo producerInfo2 = this.createProducerInfo(sessionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)producerInfo2);
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        for (int i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m1);
            connection1.send((Command)this.createAck(consumerInfo1, m1, 1, (byte)2));
        }
        connection1.request((Command)this.closeSessionInfo(sessionInfo1));
        connection2.request((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        Message msg = this.receiveMessage(connection1, 500L);
        BrokerTest.assertNull((String)"no message received from connection1 after session close", (Object)msg);
    }

    public void initCombosForTestConsumerClose() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destination", new Object[]{new ActiveMQTopic("TEST"), new ActiveMQQueue("TEST")});
    }

    public void testConsumerClose() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        consumerInfo1.setPrefetchSize(100);
        consumerInfo1.setNoLocal(true);
        connection1.request((Command)consumerInfo1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ProducerInfo producerInfo2 = this.createProducerInfo(sessionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)producerInfo2);
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        connection2.send((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        for (int i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m1);
            connection1.send((Command)this.createAck(consumerInfo1, m1, 1, (byte)2));
        }
        Message result = this.receiveMessage(connection1, 500L);
        BrokerTest.assertNull((String)("no more messages " + result), (Object)result);
        connection1.request((Command)this.closeConsumerInfo(consumerInfo1));
        connection2.request((Command)this.createMessage(producerInfo2, this.destination, this.deliveryMode));
        result = this.receiveMessage(connection1, 500L);
        BrokerTest.assertNull((String)("no message received after close " + result), (Object)result);
    }

    public void initCombosForTestTopicNoLocal() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
    }

    public void testTopicNoLocal() throws Exception {
        ActiveMQTopic destination = new ActiveMQTopic("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setRetroactive(true);
        consumerInfo1.setPrefetchSize(100);
        consumerInfo1.setNoLocal(true);
        connection1.send((Command)consumerInfo1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ProducerInfo producerInfo2 = this.createProducerInfo(sessionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)producerInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setRetroactive(true);
        consumerInfo2.setPrefetchSize(100);
        consumerInfo2.setNoLocal(true);
        connection2.send((Command)consumerInfo2);
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        for (int i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection2);
            BrokerTest.assertNotNull((Object)m1);
        }
        Message message = this.createMessage(producerInfo2, (ActiveMQDestination)destination, this.deliveryMode);
        connection2.send((Command)message);
        Message m = this.receiveMessage(connection1);
        BrokerTest.assertNotNull((Object)m);
        BrokerTest.assertEquals((Object)message.getMessageId(), (Object)m.getMessageId());
        this.assertNoMessagesLeft(connection1);
        this.assertNoMessagesLeft(connection2);
    }

    public void initCombosForTopicDispatchIsBroadcast() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
    }

    public void testTopicDispatchIsBroadcast() throws Exception {
        ActiveMQTopic destination = new ActiveMQTopic("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setRetroactive(true);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setRetroactive(true);
        consumerInfo2.setPrefetchSize(100);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)consumerInfo2);
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo1, (ActiveMQDestination)destination, this.deliveryMode));
        for (int i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m1);
            m1 = this.receiveMessage(connection2);
            BrokerTest.assertNotNull((Object)m1);
        }
    }

    public void initCombosForTestQueueDispatchedAreRedeliveredOnConsumerClose() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)5});
    }

    public void testQueueDispatchedAreRedeliveredOnConsumerClose() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        connection1.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection1.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        for (int i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m1);
            BrokerTest.assertFalse((boolean)m1.isRedelivered());
        }
        connection1.send((Command)this.closeConsumerInfo(consumerInfo1));
        while (connection1.getDispatchQueue().poll(0L, TimeUnit.MILLISECONDS) != null) {
        }
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo1, this.destination);
        consumerInfo2.setPrefetchSize(100);
        connection1.send((Command)consumerInfo2);
        for (int i = 0; i < 4; ++i) {
            Message m1 = this.receiveMessage(connection1);
            BrokerTest.assertNotNull((Object)m1);
            BrokerTest.assertTrue((boolean)m1.isRedelivered());
        }
    }

    public void initCombosForTestQueueBrowseMessages() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)5});
    }

    public void testQueueBrowseMessages() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        consumerInfo.setBrowser(true);
        connection.send((Command)consumerInfo);
        for (int i = 0; i < 4; ++i) {
            Message m = this.receiveMessage(connection);
            BrokerTest.assertNotNull((Object)m);
            connection.send((Command)this.createAck(consumerInfo, m, 1, (byte)0));
        }
        this.assertNoMessagesLeft(connection);
    }

    public void initCombosForTestQueueSendThenAddConsumer() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)5});
    }

    public void testQueueSendThenAddConsumer() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        connection.send((Command)consumerInfo);
        Message m = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m);
    }

    public void initCombosForTestQueueAckRemovesMessage() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)5});
    }

    public void testQueueAckRemovesMessage() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        Message message1 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        Message message2 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        connection.send((Command)message1);
        connection.send((Command)message2);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        connection.request((Command)consumerInfo);
        Message m = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m);
        BrokerTest.assertEquals((Object)m.getMessageId(), (Object)message1.getMessageId());
        BrokerTest.assertTrue((this.countMessagesInQueue(connection, connectionInfo, this.destination) == 2 ? 1 : 0) != 0);
        connection.send((Command)this.createAck(consumerInfo, m, 1, (byte)0));
        BrokerTest.assertTrue((this.countMessagesInQueue(connection, connectionInfo, this.destination) == 2 ? 1 : 0) != 0);
        connection.send((Command)this.createAck(consumerInfo, m, 1, (byte)2));
        BrokerTest.assertTrue((this.countMessagesInQueue(connection, connectionInfo, this.destination) == 1 ? 1 : 0) != 0);
    }

    public void initCombosForTestSelectorSkipsMessages() {
        this.addCombinationValues("destination", new Object[]{new ActiveMQTopic("TEST_TOPIC"), new ActiveMQQueue("TEST_QUEUE")});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testSelectorSkipsMessages() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        consumerInfo.setSelector("JMSType='last'");
        connection.send((Command)consumerInfo);
        Message message1 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        message1.setType("first");
        Message message2 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        message2.setType("last");
        connection.send((Command)message1);
        connection.send((Command)message2);
        Message m = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m);
        BrokerTest.assertEquals((Object)m.getMessageId(), (Object)message2.getMessageId());
        connection.send((Command)this.createAck(consumerInfo, m, 1, (byte)2));
        connection.send((Command)this.closeConsumerInfo(consumerInfo));
        this.assertNoMessagesLeft(connection);
    }

    public void initCombosForTestAddConsumerThenSend() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testAddConsumerThenSend() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        connection.send((Command)consumerInfo);
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        Message m = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m);
    }

    public void initCombosForTestConsumerPrefetchAtOne() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testConsumerPrefetchAtOne() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        consumerInfo.setPrefetchSize(1);
        connection.send((Command)consumerInfo);
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        Message m = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m);
        this.assertNoMessagesLeft(connection);
    }

    public void initCombosForTestConsumerPrefetchAtTwo() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testConsumerPrefetchAtTwo() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        consumerInfo.setPrefetchSize(2);
        connection.send((Command)consumerInfo);
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        Message m = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m);
        m = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m);
        this.assertNoMessagesLeft(connection);
    }

    public void initCombosForTestConsumerPrefetchAndDeliveredAck() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testConsumerPrefetchAndDeliveredAck() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        consumerInfo.setPrefetchSize(1);
        connection.request((Command)consumerInfo);
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        connection.request((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        Message m1 = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m1);
        this.assertNoMessagesLeft(connection);
        connection.request((Command)this.createAck(consumerInfo, m1, 1, (byte)0));
        Message m2 = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m2);
        connection.request((Command)this.createAck(consumerInfo, m2, 1, (byte)0));
        Message m3 = this.receiveMessage(connection);
        BrokerTest.assertNotNull((Object)m3);
        connection.request((Command)this.createAck(consumerInfo, m3, 1, (byte)0));
    }

    public void testGetServices() throws Exception {
        BrokerTest.assertTrue((this.broker.getServices().length != 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return BrokerTest.suite(BrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)BrokerTest.suite());
    }
}

