/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.broker.scheduler.Job;
import org.apache.activemq.broker.scheduler.JobListener;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.broker.scheduler.JobSchedulerStore;
import org.apache.activemq.store.kahadb.scheduler.JobSchedulerStoreImpl;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobSchedulerTest {
    private JobSchedulerStore store;
    private JobScheduler scheduler;

    @Test
    public void testAddLongStringByteSequence() throws Exception {
        int COUNT = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                latch.countDown();
            }
        });
        for (int i = 0; i < 10; ++i) {
            String test = new String("test" + i);
            this.scheduler.schedule("id" + i, new ByteSequence(test.getBytes()), 1000L);
        }
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testAddCronAndByteSequence() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                latch.countDown();
            }
        });
        Calendar current = Calendar.getInstance();
        current.add(12, 1);
        int minutes = current.get(12);
        int hour = current.get(11);
        int day = current.get(7) - 1;
        String cronTab = String.format("%d %d * * %d", minutes, hour, day);
        String str = new String("test1");
        this.scheduler.schedule("id:1", new ByteSequence(str.getBytes()), cronTab, 0L, 0L, 0);
        Assert.assertTrue((boolean)latch.await(70L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testAddLongLongIntStringByteSequence() throws Exception {
        int COUNT = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                latch.countDown();
            }
        });
        long time = 2000L;
        for (int i = 0; i < 10; ++i) {
            String test = new String("test" + i);
            this.scheduler.schedule("id" + i, new ByteSequence(test.getBytes()), "", time, 10L, -1);
        }
        Assert.assertTrue((latch.getCount() == 10L ? 1 : 0) != 0);
        latch.await(3000L, TimeUnit.SECONDS);
        Assert.assertTrue((latch.getCount() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testAddStopThenDeliver() throws Exception {
        int COUNT = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        long time = 2000L;
        for (int i = 0; i < 10; ++i) {
            String test = new String("test" + i);
            this.scheduler.schedule("id" + i, new ByteSequence(test.getBytes()), "", time, 1000L, -1);
        }
        File directory = this.store.getDirectory();
        this.tearDown();
        this.startStore(directory);
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                latch.countDown();
            }
        });
        Assert.assertTrue((latch.getCount() == 10L ? 1 : 0) != 0);
        latch.await(3000L, TimeUnit.SECONDS);
        Assert.assertTrue((latch.getCount() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveLong() throws Exception {
        int COUNT = 10;
        long time = 60000L;
        for (int i = 0; i < 10; ++i) {
            String str = new String("test" + i);
            this.scheduler.schedule("id" + i, new ByteSequence(str.getBytes()), "", time, 1000L, -1);
        }
        int size = this.scheduler.getAllJobs().size();
        Assert.assertEquals((long)size, (long)10L);
        long removeTime = this.scheduler.getNextScheduleTime();
        this.scheduler.remove(removeTime);
        if (size != 0) {
            removeTime = this.scheduler.getNextScheduleTime();
            this.scheduler.remove(removeTime);
        }
        size = this.scheduler.getAllJobs().size();
        Assert.assertEquals((long)0L, (long)size);
    }

    @Test
    public void testRemoveString() throws Exception {
        int COUNT = 10;
        String test = "TESTREMOVE";
        long time = 20000L;
        for (int i = 0; i < 10; ++i) {
            String str = new String("test" + i);
            this.scheduler.schedule("id" + i, new ByteSequence(str.getBytes()), "", time, 1000L, -1);
            if (i != 5) continue;
            this.scheduler.schedule("TESTREMOVE", new ByteSequence("TESTREMOVE".getBytes()), "", time, 1000L, -1);
        }
        int size = this.scheduler.getAllJobs().size();
        Assert.assertEquals((long)size, (long)11L);
        this.scheduler.remove("TESTREMOVE");
        size = this.scheduler.getAllJobs().size();
        Assert.assertEquals((long)size, (long)10L);
    }

    @Test
    public void testgetAllJobs() throws Exception {
        int COUNT = 10;
        String ID = "id:";
        long time = 20000L;
        for (int i = 0; i < 10; ++i) {
            String str = new String("test" + i);
            this.scheduler.schedule("id:" + i, new ByteSequence(str.getBytes()), "", time, (long)(10 + i), -1);
        }
        List list = this.scheduler.getAllJobs();
        Assert.assertEquals((long)list.size(), (long)10L);
        int count = 0;
        for (Job job : list) {
            Assert.assertEquals((Object)job.getJobId(), (Object)("id:" + count));
            ++count;
        }
    }

    @Test
    public void testgetAllJobsInRange() throws Exception {
        int COUNT = 10;
        String ID = "id:";
        long start = 10000L;
        for (int i = 0; i < 10; ++i) {
            String str = new String("test" + i);
            this.scheduler.schedule("id:" + i, new ByteSequence(str.getBytes()), "", start + (long)(i * 1000), (long)(10000 + i), 0);
        }
        start = System.currentTimeMillis();
        long finish = start + 12000L + 10000L;
        List list = this.scheduler.getAllJobs(start, finish);
        Assert.assertEquals((long)10L, (long)list.size());
        int count = 0;
        for (Job job : list) {
            Assert.assertEquals((Object)job.getJobId(), (Object)("id:" + count));
            ++count;
        }
    }

    @Test
    public void testRemoveAllJobsInRange() throws Exception {
        int COUNT = 10;
        String ID = "id:";
        long start = 10000L;
        for (int i = 0; i < 10; ++i) {
            String str = new String("test" + i);
            this.scheduler.schedule("id:" + i, new ByteSequence(str.getBytes()), "", start + (long)(i * 1000), (long)(10000 + i), 0);
        }
        start = System.currentTimeMillis();
        long finish = start + 12000L + 10000L;
        this.scheduler.removeAllJobs(start, finish);
        Assert.assertTrue((boolean)this.scheduler.getAllJobs().isEmpty());
    }

    @Before
    public void setUp() throws Exception {
        File directory = new File("target/test/ScheduledJobsDB");
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.startStore(directory);
    }

    protected void startStore(File directory) throws Exception {
        this.store = new JobSchedulerStoreImpl();
        this.store.setDirectory(directory);
        this.store.start();
        this.scheduler = this.store.getJobScheduler("test");
    }

    @After
    public void tearDown() throws Exception {
        this.store.stop();
    }
}

