/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KahaDBVersionTest
extends TestCase {
    static String basedir;
    static final Logger LOG;
    static final File VERSION_1_DB;
    static final File VERSION_2_DB;
    static final File VERSION_3_DB;
    BrokerService broker = null;

    protected BrokerService createBroker(KahaDBPersistenceAdapter kaha) throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistenceAdapter((PersistenceAdapter)kaha);
        this.broker.start();
        return this.broker;
    }

    protected void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void XtestCreateStore() throws Exception {
        KahaDBPersistenceAdapter kaha = new KahaDBPersistenceAdapter();
        File dir = new File("src/test/resources/org/apache/activemq/store/kahadb/KahaDBVersionX");
        IOHelper.deleteFile((File)dir);
        kaha.setDirectory(dir);
        kaha.setJournalMaxFileLength(0x100000);
        BrokerService broker = this.createBroker(kaha);
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = cf.createConnection();
        connection.setClientID("test");
        connection.start();
        this.producerSomeMessages(connection, 1000);
        connection.close();
        broker.stop();
    }

    private void producerSomeMessages(Connection connection, int numToSend) throws Exception {
        TextMessage msg;
        int i;
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic("test.topic");
        Queue queue = session.createQueue("test.queue");
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "test");
        consumer.close();
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.setPriority(9);
        for (i = 0; i < numToSend; ++i) {
            msg = session.createTextMessage("test message:" + i);
            producer.send((Message)msg);
        }
        LOG.info("sent " + numToSend + " to topic");
        producer = session.createProducer((Destination)queue);
        for (i = 0; i < numToSend; ++i) {
            msg = session.createTextMessage("test message:" + i);
            producer.send((Message)msg);
        }
        LOG.info("sent " + numToSend + " to queue");
    }

    public void testVersion1Conversion() throws Exception {
        this.doConvertRestartCycle(VERSION_1_DB);
    }

    public void testVersion2Conversion() throws Exception {
        this.doConvertRestartCycle(VERSION_2_DB);
    }

    public void testVersion3Conversion() throws Exception {
        this.doConvertRestartCycle(VERSION_3_DB);
    }

    public void doConvertRestartCycle(File existingStore) throws Exception {
        File testDir = new File("target/activemq-data/kahadb/versionDB");
        IOHelper.deleteFile((File)testDir);
        IOHelper.copyFile((File)existingStore, (File)testDir);
        int numToSend = 1000;
        for (int repeats = 0; repeats < 3; ++repeats) {
            KahaDBPersistenceAdapter kaha = new KahaDBPersistenceAdapter();
            kaha.setDirectory(testDir);
            kaha.setJournalMaxFileLength(0x100000);
            BrokerService broker = this.createBroker(kaha);
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
            Connection connection = cf.createConnection();
            connection.setClientID("test");
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic("test.topic");
            Queue queue = session.createQueue("test.queue");
            if (repeats > 0) {
                this.producerSomeMessages(connection, 1000);
            }
            MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
            int count = 0;
            for (int i = 0; i < (repeats == 0 ? 1000 : 1000); ++i) {
                TextMessage msg = (TextMessage)queueConsumer.receive(10000L);
                ++count;
                KahaDBVersionTest.assertNotNull((Object)msg);
            }
            LOG.info("Consumed " + count + " from queue");
            count = 0;
            TopicSubscriber topicConsumer = session.createDurableSubscriber(topic, "test");
            for (int i = 0; i < (repeats == 0 ? 1000 : 1000); ++i) {
                TextMessage msg = (TextMessage)topicConsumer.receive(10000L);
                KahaDBVersionTest.assertNotNull((String)("" + ++count), (Object)msg);
            }
            LOG.info("Consumed " + count + " from topic");
            connection.close();
            broker.stop();
        }
    }

    static {
        try {
            ProtectionDomain protectionDomain = KahaDBVersionTest.class.getProtectionDomain();
            basedir = new File(new File(protectionDomain.getCodeSource().getLocation().getPath()), "../..").getCanonicalPath();
        }
        catch (IOException e) {
            basedir = ".";
        }
        LOG = LoggerFactory.getLogger(KahaDBVersionTest.class);
        VERSION_1_DB = new File(basedir + "/src/test/resources/org/apache/activemq/store/kahadb/KahaDBVersion1");
        VERSION_2_DB = new File(basedir + "/src/test/resources/org/apache/activemq/store/kahadb/KahaDBVersion2");
        VERSION_3_DB = new File(basedir + "/src/test/resources/org/apache/activemq/store/kahadb/KahaDBVersion3");
    }
}

