/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.plist;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.store.PList;
import org.apache.activemq.store.PListEntry;
import org.apache.activemq.store.kahadb.plist.PListImpl;
import org.apache.activemq.store.kahadb.plist.PListStoreImpl;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PListTest {
    static final Logger LOG = LoggerFactory.getLogger(PListTest.class);
    private PListStoreImpl store;
    private PListImpl plist;
    final ByteSequence payload = new ByteSequence(new byte[400]);
    final String idSeed = new String("Seed" + new byte[1024]);
    final Vector<Throwable> exceptions = new Vector();
    ExecutorService executor;
    final int numRepeats = 1;
    Map<PList, Object> locks = new HashMap<PList, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PListEntry getFirst(PList plist) throws IOException {
        PList.PListIterator iterator = plist.iterator();
        try {
            if (iterator.hasNext()) {
                PListEntry pListEntry = (PListEntry)iterator.next();
                return pListEntry;
            }
            PListEntry pListEntry = null;
            return pListEntry;
        }
        finally {
            iterator.release();
        }
    }

    @Test
    public void testAddLast() throws Exception {
        int COUNT = 1000;
        LinkedHashMap<String, ByteSequence> map = new LinkedHashMap<String, ByteSequence>();
        for (int i = 0; i < 1000; ++i) {
            String test = new String("test" + i);
            ByteSequence bs = new ByteSequence(test.getBytes());
            map.put(test, bs);
            this.plist.addLast(test, bs);
        }
        Assert.assertEquals((long)this.plist.size(), (long)1000L);
        int count = 0;
        for (ByteSequence bs : map.values()) {
            String origStr = new String(bs.getData(), bs.getOffset(), bs.getLength());
            PListEntry entry = this.plist.get((long)count);
            String plistString = new String(entry.getByteSequence().getData(), entry.getByteSequence().getOffset(), entry.getByteSequence().getLength());
            Assert.assertEquals((Object)origStr, (Object)plistString);
            ++count;
        }
    }

    @Test
    public void testAddFirst() throws Exception {
        int COUNT = 1000;
        LinkedHashMap<String, ByteSequence> map = new LinkedHashMap<String, ByteSequence>();
        for (int i = 0; i < 1000; ++i) {
            String test = new String("test" + i);
            ByteSequence bs = new ByteSequence(test.getBytes());
            map.put(test, bs);
            this.plist.addFirst(test, bs);
        }
        Assert.assertEquals((long)this.plist.size(), (long)1000L);
        long count = this.plist.size() - 1L;
        for (ByteSequence bs : map.values()) {
            String origStr = new String(bs.getData(), bs.getOffset(), bs.getLength());
            PListEntry entry = this.plist.get(count);
            String plistString = new String(entry.getByteSequence().getData(), entry.getByteSequence().getOffset(), entry.getByteSequence().getLength());
            Assert.assertEquals((Object)origStr, (Object)plistString);
            --count;
        }
    }

    @Test
    public void testRemove() throws IOException {
        this.doTestRemove(2000);
    }

    protected void doTestRemove(int COUNT) throws IOException {
        LinkedHashMap<String, ByteSequence> map = new LinkedHashMap<String, ByteSequence>();
        for (int i = 0; i < COUNT; ++i) {
            String test = new String("test" + i);
            ByteSequence bs = new ByteSequence(test.getBytes());
            map.put(test, bs);
            this.plist.addLast(test, bs);
        }
        Assert.assertEquals((long)this.plist.size(), (long)COUNT);
        PListEntry entry = this.plist.getFirst();
        while (entry != null) {
            this.plist.remove(entry.getId());
            entry = this.plist.getFirst();
        }
        Assert.assertEquals((long)0L, (long)this.plist.size());
    }

    @Test
    public void testDestroy() throws Exception {
        this.doTestRemove(1);
        this.plist.destroy();
        Assert.assertEquals((long)0L, (long)this.plist.size());
    }

    @Test
    public void testDestroyNonEmpty() throws Exception {
        int COUNT = 1000;
        LinkedHashMap<String, ByteSequence> map = new LinkedHashMap<String, ByteSequence>();
        for (int i = 0; i < 1000; ++i) {
            String test = new String("test" + i);
            ByteSequence bs = new ByteSequence(test.getBytes());
            map.put(test, bs);
            this.plist.addLast(test, bs);
        }
        this.plist.destroy();
        Assert.assertEquals((long)0L, (long)this.plist.size());
    }

    @Test
    public void testRemoveSecond() throws Exception {
        this.plist.addLast("First", new ByteSequence("A".getBytes()));
        this.plist.addLast("Second", new ByteSequence("B".getBytes()));
        Assert.assertTrue((boolean)this.plist.remove("Second"));
        Assert.assertTrue((boolean)this.plist.remove("First"));
        Assert.assertFalse((boolean)this.plist.remove("doesNotExist"));
    }

    @Test
    public void testRemoveSingleEntry() throws Exception {
        this.plist.addLast("First", new ByteSequence("A".getBytes()));
        PList.PListIterator iterator = this.plist.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Test
    public void testRemoveSecondPosition() throws Exception {
        this.plist.addLast("First", new ByteSequence("A".getBytes()));
        this.plist.addLast("Second", new ByteSequence("B".getBytes()));
        Assert.assertTrue((boolean)this.plist.remove(1L));
        Assert.assertTrue((boolean)this.plist.remove(0L));
        Assert.assertFalse((boolean)this.plist.remove(0L));
    }

    @Test
    public void testConcurrentAddRemove() throws Exception {
        File directory = this.store.getDirectory();
        this.store.stop();
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.store = new PListStoreImpl();
        this.store.setCleanupInterval(400L);
        this.store.setDirectory(directory);
        this.store.setJournalMaxFileLength(5120);
        this.store.setLazyInit(false);
        this.store.start();
        final ByteSequence payload = new ByteSequence(new byte[2048]);
        final Vector exceptions = new Vector();
        int iterations = 1000;
        int numLists = 10;
        final PList[] lists = new PList[10];
        String threadName = Thread.currentThread().getName();
        for (int i = 0; i < 10; ++i) {
            Thread.currentThread().setName("C:" + String.valueOf(i));
            lists[i] = this.store.getPList(String.valueOf(i));
        }
        Thread.currentThread().setName(threadName);
        this.executor = Executors.newFixedThreadPool(100);
        class A
        implements Runnable {
            A() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String threadName = Thread.currentThread().getName();
                try {
                    for (int i = 0; i < 1000; ++i) {
                        PList candidate = lists[i % 10];
                        Thread.currentThread().setName("ALRF:" + candidate.getName());
                        Object object = PListTest.this.plistLocks(candidate);
                        synchronized (object) {
                            Object locator = candidate.addLast(String.valueOf(i), payload);
                            PListTest.this.getFirst(candidate);
                            Assert.assertTrue((boolean)candidate.remove(locator));
                            continue;
                        }
                    }
                }
                catch (Exception error) {
                    LOG.error("Unexpcted ex", (Throwable)error);
                    error.printStackTrace();
                    exceptions.add(error);
                }
                finally {
                    Thread.currentThread().setName(threadName);
                }
            }
        }
        this.executor.execute(new A());
        this.executor.execute(new A());
        this.executor.execute(new A());
        class B
        implements Runnable {
            B() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String threadName = Thread.currentThread().getName();
                try {
                    for (int i = 0; i < 1000; ++i) {
                        PList candidate = lists[i % 10];
                        Thread.currentThread().setName("ALRF:" + candidate.getName());
                        Object object = PListTest.this.plistLocks(candidate);
                        synchronized (object) {
                            Object locator = candidate.addLast(String.valueOf(i), payload);
                            PListTest.this.getFirst(candidate);
                            Assert.assertTrue((boolean)candidate.remove(locator));
                            continue;
                        }
                    }
                }
                catch (Exception error) {
                    error.printStackTrace();
                    exceptions.add(error);
                }
                finally {
                    Thread.currentThread().setName(threadName);
                }
            }
        }
        this.executor.execute(new B());
        this.executor.execute(new B());
        this.executor.execute(new B());
        this.executor.shutdown();
        boolean finishedInTime = this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"no exceptions", (boolean)exceptions.isEmpty());
        Assert.assertTrue((String)"finished ok", (boolean)finishedInTime);
    }

    @Test
    public void testConcurrentAddLast() throws Exception {
        int i;
        File directory = this.store.getDirectory();
        this.store.stop();
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.store = new PListStoreImpl();
        this.store.setDirectory(directory);
        this.store.start();
        int numThreads = 20;
        int iterations = 1000;
        this.executor = Executors.newFixedThreadPool(100);
        for (i = 0; i < 20; ++i) {
            new Job(i, TaskType.ADD, 1000).run();
        }
        for (i = 0; i < 20; ++i) {
            this.executor.execute(new Job(i, TaskType.ITERATE, 1000));
        }
        for (i = 0; i < 100; ++i) {
            this.executor.execute(new Job(i + 20, TaskType.ADD, 100));
        }
        this.executor.shutdown();
        boolean finishedInTime = this.executor.awaitTermination(300L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"finished ok", (boolean)finishedInTime);
    }

    @Test
    public void testOverFlow() throws Exception {
        File directory = this.store.getDirectory();
        this.store.stop();
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.store = new PListStoreImpl();
        this.store.setDirectory(directory);
        this.store.start();
        for (int i = 0; i < 2000; ++i) {
            new Job(i, TaskType.ADD, 5).run();
        }
        LOG.info("After Load index file: " + this.store.pageFile.getFile().length());
        LOG.info("After remove index file: " + this.store.pageFile.getFile().length());
    }

    @Test
    public void testConcurrentAddRemoveWithPreload() throws Exception {
        int i;
        File directory = this.store.getDirectory();
        this.store.stop();
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.store = new PListStoreImpl();
        this.store.setDirectory(directory);
        this.store.setJournalMaxFileLength(5120);
        this.store.setCleanupInterval(5000L);
        this.store.setIndexWriteBatchSize(500);
        this.store.start();
        int iterations = 500;
        int numLists = 10;
        LOG.info("create");
        for (i = 0; i < 10; ++i) {
            new Job(i, TaskType.CREATE, 500).run();
        }
        LOG.info("delete");
        for (i = 0; i < 10; ++i) {
            new Job(i, TaskType.DELETE, 500).run();
        }
        LOG.info("fill");
        for (i = 0; i < 10; ++i) {
            new Job(i, TaskType.ADD, 500).run();
        }
        LOG.info("remove");
        for (i = 0; i < 10; ++i) {
            new Job(i, TaskType.REMOVE, 500).run();
        }
        LOG.info("check empty");
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((String)("empty " + i), (long)0L, (long)this.store.getPList("List-" + i).size());
        }
        LOG.info("delete again");
        for (i = 0; i < 10; ++i) {
            new Job(i, TaskType.DELETE, 500).run();
        }
        LOG.info("fill again");
        for (i = 0; i < 10; ++i) {
            new Job(i, TaskType.ADD, 500).run();
        }
        LOG.info("parallel add and remove");
        this.executor = Executors.newFixedThreadPool(20);
        for (i = 0; i < 20; ++i) {
            this.executor.execute(new Job(i, i >= 10 ? TaskType.ADD : TaskType.REMOVE, 500));
        }
        this.executor.shutdown();
        LOG.info("wait for parallel work to complete");
        boolean finishedInTime = this.executor.awaitTermination(300L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"no exceptions", (boolean)this.exceptions.isEmpty());
        Assert.assertTrue((String)"finished ok", (boolean)finishedInTime);
    }

    @Test
    public void testRepeatStressWithCache() throws Exception {
        for (int i = 0; i < 1; ++i) {
            this.do_testConcurrentAddIterateRemove(true);
        }
    }

    @Test
    public void testRepeatStressWithOutCache() throws Exception {
        for (int i = 0; i < 1; ++i) {
            this.do_testConcurrentAddIterateRemove(false);
        }
    }

    public void do_testConcurrentAddIterateRemove(boolean enablePageCache) throws Exception {
        int i;
        int i2;
        File directory = this.store.getDirectory();
        this.store.stop();
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.store = new PListStoreImpl();
        this.store.setIndexEnablePageCaching(enablePageCache);
        this.store.setIndexPageSize(2048);
        this.store.setDirectory(directory);
        this.store.start();
        int iterations = 500;
        int numLists = 10;
        LOG.info("create");
        for (i2 = 0; i2 < 10; ++i2) {
            new Job(i2, TaskType.CREATE, 500).run();
        }
        LOG.info("fill");
        for (i2 = 0; i2 < 10; ++i2) {
            new Job(i2, TaskType.ADD, 500).run();
        }
        LOG.info("parallel add and remove");
        this.executor = Executors.newFixedThreadPool(400);
        int numProducer = 5;
        int numConsumer = 10;
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.executor.execute(new Job(i, TaskType.ADD, 1000));
            }
            for (int k = 0; k < 10; ++k) {
                this.executor.execute(new Job(i, TaskType.ITERATE_REMOVE, 125));
            }
        }
        for (i = 10; i < 100; ++i) {
            this.executor.execute(new Job(i, TaskType.ADD, 500));
        }
        this.executor.shutdown();
        LOG.info("wait for parallel work to complete");
        boolean shutdown = this.executor.awaitTermination(3600L, TimeUnit.SECONDS);
        Assert.assertTrue((String)("no exceptions: " + this.exceptions), (boolean)this.exceptions.isEmpty());
        Assert.assertTrue((String)"test did not  timeout ", (boolean)shutdown);
    }

    @Test
    public void testConcurrentAddIterate() throws Exception {
        File directory = this.store.getDirectory();
        this.store.stop();
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.store = new PListStoreImpl();
        this.store.setIndexPageSize(2048);
        this.store.setJournalMaxFileLength(0x100000);
        this.store.setDirectory(directory);
        this.store.setCleanupInterval(-1L);
        this.store.setIndexEnablePageCaching(false);
        this.store.setIndexWriteBatchSize(100);
        this.store.start();
        int iterations = 250;
        int numLists = 10;
        LOG.info("create");
        for (int i = 0; i < 10; ++i) {
            new Job(i, TaskType.CREATE, 250).run();
        }
        LOG.info("parallel add and iterate");
        this.executor = Executors.newFixedThreadPool(400);
        int numProducer = 300;
        int numConsumer = 100;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 300; ++j) {
                this.executor.execute(new Job(i, TaskType.ADD, 250));
            }
            for (int k = 0; k < 100; ++k) {
                this.executor.execute(new Job(i, TaskType.ITERATE, 500));
            }
        }
        this.executor.shutdown();
        LOG.info("wait for parallel work to complete");
        boolean shutdown = this.executor.awaitTermination(3600L, TimeUnit.SECONDS);
        Assert.assertTrue((String)("no exceptions: " + this.exceptions), (boolean)this.exceptions.isEmpty());
        Assert.assertTrue((String)"test did not  timeout ", (boolean)shutdown);
        LOG.info("Num dataFiles:" + this.store.getJournal().getFiles().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object plistLocks(PList plist) {
        Object lock = null;
        Map<PList, Object> map = this.locks;
        synchronized (map) {
            if (this.locks.containsKey(plist)) {
                lock = this.locks.get(plist);
            } else {
                lock = new Object();
                this.locks.put(plist, lock);
            }
        }
        return lock;
    }

    @Before
    public void setUp() throws Exception {
        File directory = new File("target/test/PlistDB");
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.startStore(directory);
    }

    protected void startStore(File directory) throws Exception {
        this.store = new PListStoreImpl();
        this.store.setDirectory(directory);
        this.store.start();
        this.plist = this.store.getPList("main");
    }

    @After
    public void tearDown() throws Exception {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.store.stop();
        this.exceptions.clear();
    }

    class Job
    implements Runnable {
        int id;
        TaskType task;
        int iterations;

        public Job(int id, TaskType t, int iterations) {
            this.id = id;
            this.task = t;
            this.iterations = iterations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            try {
                PListImpl plist = null;
                switch (this.task) {
                    case CREATE: {
                        Thread.currentThread().setName("C:" + this.id);
                        plist = PListTest.this.store.getPList(String.valueOf(this.id));
                        LOG.info("Job-" + this.id + ", CREATE");
                        return;
                    }
                    case DELETE: {
                        Thread.currentThread().setName("D:" + this.id);
                        PListTest.this.store.removePList(String.valueOf(this.id));
                        return;
                    }
                    case ADD: {
                        Thread.currentThread().setName("A:" + this.id);
                        plist = PListTest.this.store.getPList(String.valueOf(this.id));
                        for (int j = 0; j < this.iterations; ++j) {
                            Object object = PListTest.this.plistLocks((PList)plist);
                            synchronized (object) {
                                if (PListTest.this.exceptions.isEmpty()) {
                                    plist.addLast("PL>" + this.id + PListTest.this.idSeed + "-" + j, PListTest.this.payload);
                                    continue;
                                }
                                break;
                            }
                        }
                        if (!PListTest.this.exceptions.isEmpty()) return;
                        LOG.info("Job-" + this.id + ", Add, done: " + this.iterations);
                        return;
                    }
                    case REMOVE: {
                        Thread.currentThread().setName("R:" + this.id);
                        plist = PListTest.this.store.getPList(String.valueOf(this.id));
                        Object j = PListTest.this.plistLocks((PList)plist);
                        synchronized (j) {
                            int j2 = this.iterations - 1;
                            while (j2 >= 0) {
                                plist.remove("PL>" + this.id + PListTest.this.idSeed + "-" + j2);
                                if (j2 > 0 && j2 % (this.iterations / 2) == 0) {
                                    LOG.info("Job-" + this.id + " Done remove: " + j2);
                                }
                                --j2;
                            }
                            return;
                        }
                    }
                    case ITERATE: {
                        Thread.currentThread().setName("I:" + this.id);
                        plist = PListTest.this.store.getPList(String.valueOf(this.id));
                        int iterateCount = 0;
                        Object j2 = PListTest.this.plistLocks((PList)plist);
                        synchronized (j2) {
                            if (!PListTest.this.exceptions.isEmpty()) return;
                            PList.PListIterator iterator = plist.iterator();
                            while (iterator.hasNext() && PListTest.this.exceptions.isEmpty()) {
                                iterator.next();
                                ++iterateCount;
                            }
                            if (plist.size() != (long)iterateCount) {
                                System.err.println("Count Wrong: " + iterator);
                            }
                            Assert.assertEquals((String)("iterate got all " + this.id + " iterator:" + iterator), (long)plist.size(), (long)iterateCount);
                            return;
                        }
                    }
                    case ITERATE_REMOVE: {
                        Thread.currentThread().setName("IRM:" + this.id);
                        plist = PListTest.this.store.getPList(String.valueOf(this.id));
                        int removeCount = 0;
                        Object object = PListTest.this.plistLocks((PList)plist);
                        synchronized (object) {
                            PList.PListIterator removeIterator = plist.iterator();
                            while (removeIterator.hasNext()) {
                                removeIterator.next();
                                removeIterator.remove();
                                if (removeCount++ <= this.iterations) continue;
                            }
                        }
                        LOG.info("Job-" + this.id + " Done remove: " + removeCount);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                LOG.warn("Job[" + this.id + "] caught exception: " + e.getMessage());
                e.printStackTrace();
                PListTest.this.exceptions.add(e);
                if (PListTest.this.executor == null) return;
                PListTest.this.executor.shutdownNow();
                return;
            }
            finally {
                Thread.currentThread().setName(threadName);
            }
        }
    }

    static enum TaskType {
        CREATE,
        DELETE,
        ADD,
        REMOVE,
        ITERATE,
        ITERATE_REMOVE;

    }
}

