/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.streams;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQInputStream;
import org.apache.activemq.ActiveMQOutputStream;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;

public class JMSInputStreamTest
extends JmsTestSupport {
    public Destination destination;
    protected DataOutputStream out;
    protected DataInputStream in;
    private ActiveMQConnection connection2;
    private ActiveMQInputStream amqIn;
    private ActiveMQOutputStream amqOut;

    public static Test suite() {
        return JMSInputStreamTest.suite(JMSInputStreamTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)JMSInputStreamTest.suite());
    }

    public void initCombos() {
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST.QUEUE"), new ActiveMQTopic("TEST.TOPIC")});
    }

    @Override
    protected void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
    }

    private void setUpConnection(Map<String, Object> props, long timeout) throws JMSException {
        this.connection2 = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
        this.connections.add(this.connection2);
        this.amqOut = props != null ? (ActiveMQOutputStream)this.connection.createOutputStream(this.destination, props, 2, 4, 0L) : (ActiveMQOutputStream)this.connection.createOutputStream(this.destination);
        this.out = new DataOutputStream((OutputStream)this.amqOut);
        this.amqIn = timeout == -1L ? (ActiveMQInputStream)this.connection2.createInputStream(this.destination) : (ActiveMQInputStream)this.connection2.createInputStream(this.destination, null, false, timeout);
        this.in = new DataInputStream((InputStream)this.amqIn);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInputStreamTimeout() throws Exception {
        long timeout = 500L;
        this.setUpConnection(null, timeout);
        try {
            this.in.read();
            JMSInputStreamTest.fail();
        }
        catch (ActiveMQInputStream.ReadTimeoutException readTimeoutException) {
            // empty catch block
        }
        this.in.close();
    }

    public void testStreamsWithProperties() throws Exception {
        int i;
        String name1 = "PROPERTY_1";
        String name2 = "PROPERTY_2";
        String value1 = "VALUE_1";
        String value2 = "VALUE_2";
        HashMap<String, Object> jmsProperties = new HashMap<String, Object>();
        jmsProperties.put(name1, value1);
        jmsProperties.put(name2, value2);
        this.setUpConnection(jmsProperties, -1L);
        this.out.writeInt(4);
        this.out.flush();
        JMSInputStreamTest.assertTrue((this.in.readInt() == 4 ? 1 : 0) != 0);
        this.out.writeFloat(2.3f);
        this.out.flush();
        JMSInputStreamTest.assertTrue((this.in.readFloat() == 2.3f ? 1 : 0) != 0);
        String str = "this is a test string";
        this.out.writeUTF(str);
        this.out.flush();
        JMSInputStreamTest.assertTrue((boolean)this.in.readUTF().equals(str));
        for (i = 0; i < 100; ++i) {
            this.out.writeLong(i);
        }
        this.out.flush();
        this.checkProperties(jmsProperties);
        for (i = 0; i < 100; ++i) {
            JMSInputStreamTest.assertTrue((this.in.readLong() == (long)i ? 1 : 0) != 0);
        }
        this.checkProperties(jmsProperties);
    }

    public void testStreamsWithPropertiesOnlyOnFirstMessage() throws Exception {
        int i;
        String name1 = "PROPERTY_1";
        String name2 = "PROPERTY_2";
        String value1 = "VALUE_1";
        String value2 = "VALUE_2";
        HashMap<String, Object> jmsProperties = new HashMap<String, Object>();
        jmsProperties.put(name1, value1);
        jmsProperties.put(name2, value2);
        ActiveMQDestination dest = (ActiveMQDestination)this.destination;
        this.destination = dest.isQueue() ? new ActiveMQQueue(dest.getPhysicalName() + "?producer.addPropertiesOnFirstMsgOnly=true") : new ActiveMQTopic(dest.getPhysicalName() + "?producer.addPropertiesOnFirstMsgOnly=true");
        this.setUpConnection(jmsProperties, -1L);
        JMSInputStreamTest.assertTrue((boolean)this.amqOut.isAddPropertiesOnFirstMsgOnly());
        this.out.writeInt(4);
        this.out.flush();
        JMSInputStreamTest.assertTrue((this.in.readInt() == 4 ? 1 : 0) != 0);
        this.out.writeFloat(2.3f);
        this.out.flush();
        JMSInputStreamTest.assertTrue((this.in.readFloat() == 2.3f ? 1 : 0) != 0);
        String str = "this is a test string";
        this.out.writeUTF(str);
        this.out.flush();
        JMSInputStreamTest.assertTrue((boolean)this.in.readUTF().equals(str));
        for (i = 0; i < 100; ++i) {
            this.out.writeLong(i);
        }
        this.out.flush();
        this.checkProperties(jmsProperties);
        for (i = 0; i < 100; ++i) {
            JMSInputStreamTest.assertTrue((this.in.readLong() == (long)i ? 1 : 0) != 0);
        }
        this.checkProperties(jmsProperties);
    }

    private void checkProperties(Map<String, Object> jmsProperties) throws IOException {
        Map receivedJmsProps = this.amqIn.getJMSProperties();
        JMSInputStreamTest.assertTrue((jmsProperties.size() <= receivedJmsProps.size() ? 1 : 0) != 0);
        for (String key : jmsProperties.keySet()) {
            JMSInputStreamTest.assertTrue((boolean)receivedJmsProps.containsKey(key));
            JMSInputStreamTest.assertEquals((Object)jmsProperties.get(key), receivedJmsProps.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLarge() throws Exception {
        this.setUpConnection(null, -1L);
        int testData = 23;
        int dataLength = 4096;
        int count = 1024;
        byte[] data = new byte[4096];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 23;
        }
        final AtomicBoolean complete = new AtomicBoolean(false);
        Thread runner = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int x = 0; x < 1024; ++x) {
                        byte[] b = new byte[2048];
                        JMSInputStreamTest.this.in.readFully(b);
                        for (int i = 0; i < b.length; ++i) {
                            TestCase.assertTrue((b[i] == 23 ? 1 : 0) != 0);
                        }
                    }
                    complete.set(true);
                    AtomicBoolean x = complete;
                    synchronized (x) {
                        complete.notify();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        runner.start();
        for (int i = 0; i < 1024; ++i) {
            this.out.write(data);
        }
        this.out.flush();
        AtomicBoolean atomicBoolean = complete;
        synchronized (atomicBoolean) {
            if (!complete.get()) {
                complete.wait(30000L);
            }
        }
        JMSInputStreamTest.assertTrue((boolean)complete.get());
    }

    public void testStreams() throws Exception {
        int i;
        this.setUpConnection(null, -1L);
        this.out.writeInt(4);
        this.out.flush();
        JMSInputStreamTest.assertTrue((this.in.readInt() == 4 ? 1 : 0) != 0);
        this.out.writeFloat(2.3f);
        this.out.flush();
        JMSInputStreamTest.assertTrue((this.in.readFloat() == 2.3f ? 1 : 0) != 0);
        String str = "this is a test string";
        this.out.writeUTF(str);
        this.out.flush();
        JMSInputStreamTest.assertTrue((boolean)this.in.readUTF().equals(str));
        for (i = 0; i < 100; ++i) {
            this.out.writeLong(i);
        }
        this.out.flush();
        for (i = 0; i < 100; ++i) {
            JMSInputStreamTest.assertTrue((this.in.readLong() == (long)i ? 1 : 0) != 0);
        }
    }
}

