/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import org.apache.activemq.transport.failover.FailoverClusterTestSupport;

public class FailoverComplexClusterTest
extends FailoverClusterTestSupport {
    private static final String BROKER_A_CLIENT_TC_ADDRESS = "tcp://localhost:61616";
    private static final String BROKER_B_CLIENT_TC_ADDRESS = "tcp://localhost:61617";
    private static final String BROKER_C_CLIENT_TC_ADDRESS = "tcp://localhost:61618";
    private static final String BROKER_A_NOB_TC_ADDRESS = "tcp://localhost:61626";
    private static final String BROKER_B_NOB_TC_ADDRESS = "tcp://localhost:61627";
    private static final String BROKER_C_NOB_TC_ADDRESS = "tcp://localhost:61628";
    private static final String BROKER_A_NAME = "BROKERA";
    private static final String BROKER_B_NAME = "BROKERB";
    private static final String BROKER_C_NAME = "BROKERC";

    public void testThreeBrokerClusterSingleConnectorBasic() throws Exception {
        this.initSingleTcBroker("", null, null);
        Thread.sleep(2000L);
        this.setClientUrl("failover://(tcp://localhost:61616,tcp://localhost:61617)");
        this.createClients();
        Thread.sleep(2000L);
        this.runTests(false, null, null, null);
    }

    public void testThreeBrokerClusterSingleConnectorBackupFailoverConfig() throws Exception {
        this.initSingleTcBroker("", null, null);
        Thread.sleep(2000L);
        this.setClientUrl("failover://(tcp://localhost:61616,tcp://localhost:61617)?backup=true&backupPoolSize=2&useExponentialBackOff=false&initialReconnectDelay=500");
        this.createClients();
        Thread.sleep(2000L);
        this.runTests(false, null, null, null);
    }

    public void testThreeBrokerClusterSingleConnectorWithParams() throws Exception {
        this.initSingleTcBroker("?transport.closeAsync=false", null, null);
        Thread.sleep(2000L);
        this.setClientUrl("failover://(tcp://localhost:61616,tcp://localhost:61617)");
        this.createClients();
        Thread.sleep(2000L);
        this.runTests(false, null, null, null);
    }

    public void testThreeBrokerClusterWithClusterFilter() throws Exception {
        this.initSingleTcBroker("?transport.closeAsync=false", null, null);
        Thread.sleep(2000L);
        this.setClientUrl("failover://(tcp://localhost:61616,tcp://localhost:61617)");
        this.createClients();
        this.runTests(false, null, "*", null);
    }

    public void testThreeBrokerClusterMultipleConnectorBasic() throws Exception {
        this.initMultiTcCluster("", null);
        Thread.sleep(2000L);
        this.setClientUrl("failover://(tcp://localhost:61616,tcp://localhost:61617)");
        this.createClients();
        Thread.sleep(2000L);
        this.runTests(true, null, null, null);
    }

    public void testOriginalBrokerRestart() throws Exception {
        this.initSingleTcBroker("", null, null);
        Thread.sleep(2000L);
        this.setClientUrl("failover://(tcp://localhost:61616,tcp://localhost:61617)");
        this.createClients();
        Thread.sleep(2000L);
        this.assertClientsConnectedToThreeBrokers();
        this.getBroker(BROKER_A_NAME).stop();
        this.getBroker(BROKER_A_NAME).waitUntilStopped();
        this.removeBroker(BROKER_A_NAME);
        Thread.sleep(5000L);
        this.assertClientsConnectedToTwoBrokers();
        this.createBrokerA(false, null, null, null);
        this.getBroker(BROKER_A_NAME).waitUntilStarted();
        Thread.sleep(5000L);
        this.assertClientsConnectedToThreeBrokers();
    }

    public void testThreeBrokerClusterClientDistributions() throws Exception {
        this.initSingleTcBroker("", null, null);
        Thread.sleep(2000L);
        this.setClientUrl("failover://(tcp://localhost:61616,tcp://localhost:61617)?useExponentialBackOff=false&initialReconnectDelay=500");
        this.createClients(100);
        Thread.sleep(5000L);
        this.runClientDistributionTests(false, null, null, null);
    }

    public void testThreeBrokerClusterDestinationFilter() throws Exception {
        this.initSingleTcBroker("", null, null);
        Thread.sleep(2000L);
        this.setClientUrl("failover://(tcp://localhost:61616,tcp://localhost:61617)");
        this.createClients();
        this.runTests(false, null, null, "Queue.TEST.FOO.>");
    }

    private void runTests(boolean multi, String tcParams, String clusterFilter, String destinationFilter) throws Exception, InterruptedException {
        this.assertClientsConnectedToThreeBrokers();
        this.getBroker(BROKER_C_NAME).stop();
        this.getBroker(BROKER_C_NAME).waitUntilStopped();
        this.removeBroker(BROKER_C_NAME);
        Thread.sleep(5000L);
        this.assertClientsConnectedToTwoBrokers();
        this.createBrokerC(multi, tcParams, clusterFilter, destinationFilter);
        this.getBroker(BROKER_C_NAME).waitUntilStarted();
        Thread.sleep(5000L);
        this.assertClientsConnectedToThreeBrokers();
    }

    private void runClientDistributionTests(boolean multi, String tcParams, String clusterFilter, String destinationFilter) throws Exception, InterruptedException {
        this.assertClientsConnectedToThreeBrokers();
        this.assertClientsConnectionsEvenlyDistributed(0.25);
        this.getBroker(BROKER_C_NAME).stop();
        this.getBroker(BROKER_C_NAME).waitUntilStopped();
        this.removeBroker(BROKER_C_NAME);
        Thread.sleep(5000L);
        this.assertClientsConnectedToTwoBrokers();
        this.assertClientsConnectionsEvenlyDistributed(0.35);
        this.createBrokerC(multi, tcParams, clusterFilter, destinationFilter);
        this.getBroker(BROKER_C_NAME).waitUntilStarted();
        Thread.sleep(5000L);
        this.assertClientsConnectedToThreeBrokers();
        this.assertClientsConnectionsEvenlyDistributed(0.2);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        this.shutdownClients();
        Thread.sleep(2000L);
        this.destroyBrokerCluster();
    }

    private void initSingleTcBroker(String params, String clusterFilter, String destinationFilter) throws Exception {
        this.createBrokerA(false, params, clusterFilter, null);
        this.createBrokerB(false, params, clusterFilter, null);
        this.createBrokerC(false, params, clusterFilter, null);
        this.getBroker(BROKER_C_NAME).waitUntilStarted();
    }

    private void initMultiTcCluster(String params, String clusterFilter) throws Exception {
        this.createBrokerA(true, params, clusterFilter, null);
        this.createBrokerB(true, params, clusterFilter, null);
        this.createBrokerC(true, params, clusterFilter, null);
        this.getBroker(BROKER_C_NAME).waitUntilStarted();
    }

    private void createBrokerA(boolean multi, String params, String clusterFilter, String destinationFilter) throws Exception {
        String tcParams;
        String string = tcParams = params == null ? "" : params;
        if (this.getBroker(BROKER_A_NAME) == null) {
            this.addBroker(BROKER_A_NAME, this.createBroker(BROKER_A_NAME));
            this.addTransportConnector(this.getBroker(BROKER_A_NAME), "openwire", BROKER_A_CLIENT_TC_ADDRESS + tcParams, true);
            if (multi) {
                this.addTransportConnector(this.getBroker(BROKER_A_NAME), "network", BROKER_A_NOB_TC_ADDRESS + tcParams, false);
                this.addNetworkBridge(this.getBroker(BROKER_A_NAME), "A_2_B_Bridge", "static://(tcp://localhost:61627)?useExponentialBackOff=false", false, clusterFilter);
                this.addNetworkBridge(this.getBroker(BROKER_A_NAME), "A_2_C_Bridge", "static://(tcp://localhost:61628)?useExponentialBackOff=false", false, null);
            } else {
                this.addNetworkBridge(this.getBroker(BROKER_A_NAME), "A_2_B_Bridge", "static://(tcp://localhost:61617)?useExponentialBackOff=false", false, clusterFilter);
                this.addNetworkBridge(this.getBroker(BROKER_A_NAME), "A_2_C_Bridge", "static://(tcp://localhost:61618)?useExponentialBackOff=false", false, null);
            }
            this.getBroker(BROKER_A_NAME).start();
        }
    }

    private void createBrokerB(boolean multi, String params, String clusterFilter, String destinationFilter) throws Exception {
        String tcParams;
        String string = tcParams = params == null ? "" : params;
        if (this.getBroker(BROKER_B_NAME) == null) {
            this.addBroker(BROKER_B_NAME, this.createBroker(BROKER_B_NAME));
            this.addTransportConnector(this.getBroker(BROKER_B_NAME), "openwire", BROKER_B_CLIENT_TC_ADDRESS + tcParams, true);
            if (multi) {
                this.addTransportConnector(this.getBroker(BROKER_B_NAME), "network", BROKER_B_NOB_TC_ADDRESS + tcParams, false);
                this.addNetworkBridge(this.getBroker(BROKER_B_NAME), "B_2_A_Bridge", "static://(tcp://localhost:61626)?useExponentialBackOff=false", false, clusterFilter);
                this.addNetworkBridge(this.getBroker(BROKER_B_NAME), "B_2_C_Bridge", "static://(tcp://localhost:61628)?useExponentialBackOff=false", false, null);
            } else {
                this.addNetworkBridge(this.getBroker(BROKER_B_NAME), "B_2_A_Bridge", "static://(tcp://localhost:61616)?useExponentialBackOff=false", false, clusterFilter);
                this.addNetworkBridge(this.getBroker(BROKER_B_NAME), "B_2_C_Bridge", "static://(tcp://localhost:61618)?useExponentialBackOff=false", false, null);
            }
            this.getBroker(BROKER_B_NAME).start();
        }
    }

    private void createBrokerC(boolean multi, String params, String clusterFilter, String destinationFilter) throws Exception {
        String tcParams;
        String string = tcParams = params == null ? "" : params;
        if (this.getBroker(BROKER_C_NAME) == null) {
            this.addBroker(BROKER_C_NAME, this.createBroker(BROKER_C_NAME));
            this.addTransportConnector(this.getBroker(BROKER_C_NAME), "openwire", BROKER_C_CLIENT_TC_ADDRESS + tcParams, true);
            if (multi) {
                this.addTransportConnector(this.getBroker(BROKER_C_NAME), "network", BROKER_C_NOB_TC_ADDRESS + tcParams, false);
                this.addNetworkBridge(this.getBroker(BROKER_C_NAME), "C_2_A_Bridge", "static://(tcp://localhost:61626)?useExponentialBackOff=false", false, clusterFilter);
                this.addNetworkBridge(this.getBroker(BROKER_C_NAME), "C_2_B_Bridge", "static://(tcp://localhost:61627)?useExponentialBackOff=false", false, null);
            } else {
                this.addNetworkBridge(this.getBroker(BROKER_C_NAME), "C_2_A_Bridge", "static://(tcp://localhost:61616)?useExponentialBackOff=false", false, clusterFilter);
                this.addNetworkBridge(this.getBroker(BROKER_C_NAME), "C_2_B_Bridge", "static://(tcp://localhost:61617)?useExponentialBackOff=false", false, null);
            }
            this.getBroker(BROKER_C_NAME).start();
        }
    }
}

