/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SslContextNBrokerServiceTest
extends TestCase {
    private static final transient Logger LOG = LoggerFactory.getLogger(SslContextNBrokerServiceTest.class);
    private ClassPathXmlApplicationContext context;
    Map<String, BrokerService> beansOfType;

    public void testConfigurationIsolation() throws Exception {
        SslContextNBrokerServiceTest.assertTrue((String)"dummy bean has dummy cert", (boolean)this.verifyCredentials("dummy"));
        SslContextNBrokerServiceTest.assertTrue((String)"good bean has amq cert", (boolean)this.verifyCredentials("activemq.org"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyCredentials(String name) throws Exception {
        boolean result = false;
        BrokerService broker = this.getBroker(name);
        SslContextNBrokerServiceTest.assertNotNull((String)name, (Object)broker);
        broker.start();
        try {
            result = this.verifySslCredentials(broker);
        }
        finally {
            broker.stop();
        }
        return result;
    }

    private boolean verifySslCredentials(BrokerService broker) throws Exception {
        TransportConnector connector = (TransportConnector)broker.getTransportConnectors().get(0);
        URI brokerUri = connector.getConnectUri();
        SSLContext context = SSLContext.getInstance("TLS");
        CertChainCatcher catcher = new CertChainCatcher();
        context.init(null, new TrustManager[]{catcher}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        LOG.info("Connecting to broker: " + broker.getBrokerName() + " on: " + brokerUri.getHost() + ":" + brokerUri.getPort());
        SSLSocket socket = (SSLSocket)factory.createSocket(brokerUri.getHost(), brokerUri.getPort());
        socket.setSoTimeout(5000);
        socket.startHandshake();
        socket.close();
        boolean matches = false;
        if (catcher.serverCerts != null) {
            String issuer;
            for (int i = 0; i < catcher.serverCerts.length; ++i) {
                X509Certificate cert = catcher.serverCerts[i];
                LOG.info(" " + (i + 1) + " Issuer " + cert.getIssuerDN());
            }
            if (catcher.serverCerts.length > 0 && (issuer = catcher.serverCerts[0].getIssuerDN().toString()).indexOf(broker.getBrokerName()) != -1) {
                matches = true;
            }
        }
        return matches;
    }

    private BrokerService getBroker(String name) {
        BrokerService result = null;
        for (BrokerService candidate : this.beansOfType.values()) {
            if (!candidate.getBrokerName().equals(name)) continue;
            result = candidate;
            break;
        }
        return result;
    }

    protected void setUp() throws Exception {
        Thread.currentThread().setContextClassLoader(SslContextNBrokerServiceTest.class.getClassLoader());
        this.context = new ClassPathXmlApplicationContext("org/apache/activemq/transport/tcp/n-brokers-ssl.xml");
        this.beansOfType = this.context.getBeansOfType(BrokerService.class);
    }

    protected void tearDown() throws Exception {
        this.context.destroy();
    }

    class CertChainCatcher
    implements X509TrustManager {
        X509Certificate[] serverCerts;

        CertChainCatcher() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            this.serverCerts = arg0;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

