/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.TransportServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireformatNegociationTest
extends CombinationTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(WireformatNegociationTest.class);
    private TransportServer server;
    private Transport clientTransport;
    private Transport serverTransport;
    private final AtomicReference<WireFormatInfo> clientWF = new AtomicReference();
    private final AtomicReference<WireFormatInfo> serverWF = new AtomicReference();
    private final AtomicReference<Exception> asyncError = new AtomicReference();
    private final AtomicBoolean ignoreAsycError = new AtomicBoolean();
    private final CountDownLatch negociationCounter = new CountDownLatch(2);

    protected void setUp() throws Exception {
        super.setUp();
    }

    private void startClient(String uri) throws Exception, URISyntaxException {
        this.clientTransport = TransportFactory.connect((URI)new URI(uri));
        this.clientTransport.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
                if (command instanceof WireFormatInfo) {
                    WireformatNegociationTest.this.clientWF.set((WireFormatInfo)command);
                    WireformatNegociationTest.this.negociationCounter.countDown();
                }
            }

            public void onException(IOException error) {
                if (!WireformatNegociationTest.this.ignoreAsycError.get()) {
                    LOG.info("Client transport error: ", (Throwable)error);
                    WireformatNegociationTest.this.asyncError.set(error);
                    WireformatNegociationTest.this.negociationCounter.countDown();
                }
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        this.clientTransport.start();
    }

    private void startServer(String uri) throws IOException, URISyntaxException, Exception {
        this.server = TransportFactory.bind((URI)new URI(uri));
        this.server.setAcceptListener(new TransportAcceptListener(){

            public void onAccept(Transport transport) {
                try {
                    LOG.info("[" + WireformatNegociationTest.this.getName() + "] Server Accepted a Connection");
                    WireformatNegociationTest.this.serverTransport = transport;
                    WireformatNegociationTest.this.serverTransport.setTransportListener(new TransportListener(){

                        public void onCommand(Object command) {
                            if (command instanceof WireFormatInfo) {
                                WireformatNegociationTest.this.serverWF.set((WireFormatInfo)command);
                                WireformatNegociationTest.this.negociationCounter.countDown();
                            }
                        }

                        public void onException(IOException error) {
                            if (!WireformatNegociationTest.this.ignoreAsycError.get()) {
                                LOG.info("Server transport error: ", (Throwable)error);
                                WireformatNegociationTest.this.asyncError.set(error);
                                WireformatNegociationTest.this.negociationCounter.countDown();
                            }
                        }

                        public void transportInterupted() {
                        }

                        public void transportResumed() {
                        }
                    });
                    WireformatNegociationTest.this.serverTransport.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onAcceptError(Exception error) {
                error.printStackTrace();
            }
        });
        this.server.start();
    }

    protected void tearDown() throws Exception {
        this.ignoreAsycError.set(true);
        try {
            if (this.clientTransport != null) {
                this.clientTransport.stop();
            }
            if (this.serverTransport != null) {
                this.serverTransport.stop();
            }
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.tearDown();
    }

    public void testWireFormatInfoSeverVersion1() throws Exception {
        this.startServer("tcp://localhost:61616?wireFormat.version=1");
        this.startClient("tcp://localhost:61616");
        WireformatNegociationTest.assertTrue((String)"Connect timeout", (boolean)this.negociationCounter.await(10L, TimeUnit.SECONDS));
        WireformatNegociationTest.assertNull((String)("Async error: " + this.asyncError), (Object)this.asyncError.get());
        WireformatNegociationTest.assertNotNull((Object)this.clientWF.get());
        WireformatNegociationTest.assertEquals((int)1, (int)this.clientWF.get().getVersion());
        WireformatNegociationTest.assertNotNull((Object)this.serverWF.get());
        WireformatNegociationTest.assertEquals((int)1, (int)this.serverWF.get().getVersion());
    }

    public void testWireFormatInfoClientVersion1() throws Exception {
        this.startServer("tcp://localhost:61616");
        this.startClient("tcp://localhost:61616?wireFormat.version=1");
        WireformatNegociationTest.assertTrue((String)"Connect timeout", (boolean)this.negociationCounter.await(10L, TimeUnit.SECONDS));
        WireformatNegociationTest.assertNull((String)("Async error: " + this.asyncError), (Object)this.asyncError.get());
        WireformatNegociationTest.assertNotNull((Object)this.clientWF.get());
        WireformatNegociationTest.assertEquals((int)1, (int)this.clientWF.get().getVersion());
        WireformatNegociationTest.assertNotNull((Object)this.serverWF.get());
        WireformatNegociationTest.assertEquals((int)1, (int)this.serverWF.get().getVersion());
    }

    public void testWireFormatInfoCurrentVersion() throws Exception {
        this.startServer("tcp://localhost:61616");
        this.startClient("tcp://localhost:61616");
        WireformatNegociationTest.assertTrue((String)"Connect timeout", (boolean)this.negociationCounter.await(10L, TimeUnit.SECONDS));
        WireformatNegociationTest.assertNull((String)("Async error: " + this.asyncError), (Object)this.asyncError.get());
        WireformatNegociationTest.assertNotNull((Object)this.clientWF.get());
        WireformatNegociationTest.assertEquals((int)9, (int)this.clientWF.get().getVersion());
        WireformatNegociationTest.assertNotNull((Object)this.serverWF.get());
        WireformatNegociationTest.assertEquals((int)9, (int)this.serverWF.get().getVersion());
    }

    public void testWireFormatInactivityDurationInitialDelay() throws Exception {
        this.startServer("tcp://localhost:61616");
        this.startClient("tcp://localhost:61616?wireFormat.maxInactivityDurationInitalDelay=60000");
        WireformatNegociationTest.assertTrue((String)"Connect timeout", (boolean)this.negociationCounter.await(10L, TimeUnit.SECONDS));
        WireformatNegociationTest.assertNull((String)("Async error: " + this.asyncError), (Object)this.asyncError.get());
        WireformatNegociationTest.assertNotNull((Object)this.clientWF.get());
        WireformatNegociationTest.assertEquals((int)9, (int)this.clientWF.get().getVersion());
        WireformatNegociationTest.assertNotNull((Object)this.serverWF.get());
        WireformatNegociationTest.assertEquals((int)9, (int)this.serverWF.get().getVersion());
    }

    public void testWireFormatMaxFrameSize() throws Exception {
        this.startServer("tcp://localhost:61616");
        this.startClient("tcp://localhost:61616?wireFormat.maxFrameSize=1048576");
        WireformatNegociationTest.assertTrue((String)"Connect timeout", (boolean)this.negociationCounter.await(10L, TimeUnit.SECONDS));
        WireformatNegociationTest.assertNull((String)("Async error: " + this.asyncError), (Object)this.asyncError.get());
        WireformatNegociationTest.assertNotNull((Object)this.clientWF.get());
        WireformatNegociationTest.assertEquals((long)0x100000L, (long)this.clientWF.get().getMaxFrameSize());
        WireformatNegociationTest.assertNotNull((Object)this.serverWF.get());
        WireformatNegociationTest.assertEquals((long)0x100000L, (long)this.serverWF.get().getMaxFrameSize());
    }
}

