/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.io.File;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.ProducerThread;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerStoreUsageTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JobSchedulerStoreUsageTest.class);
    final int WAIT_TIME_MILLS = 20000;

    @Override
    protected BrokerService createBroker() throws Exception {
        File schedulerDirectory = new File("target/scheduler");
        IOHelper.mkdirs((File)schedulerDirectory);
        IOHelper.deleteChildren((File)schedulerDirectory);
        BrokerService broker = super.createBroker();
        broker.setSchedulerSupport(true);
        broker.setSchedulerDirectoryFile(schedulerDirectory);
        broker.getSystemUsage().getJobSchedulerUsage().setLimit(7168L);
        broker.deleteAllMessages();
        return broker;
    }

    @Override
    protected boolean isPersistent() {
        return true;
    }

    public void testJmx() throws Exception {
        LOG.info("Initial scheduler usage: {}", (Object)this.broker.getAdminView().getJobSchedulerStorePercentUsage());
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection conn = factory.createConnection();
        conn.start();
        Session sess = conn.createSession(false, 1);
        Queue dest = sess.createQueue(((Object)((Object)this)).getClass().getName());
        final ProducerThread producer = new ProducerThread(sess, (Destination)dest){

            @Override
            protected Message createMessage(int i) throws Exception {
                Message message = super.createMessage(i);
                message.setLongProperty("AMQ_SCHEDULED_DELAY", 10000L);
                return message;
            }
        };
        producer.setMessageCount(100);
        producer.start();
        JobSchedulerStoreUsageTest.assertEquals((long)7168L, (long)this.broker.getAdminView().getJobSchedulerStoreLimit());
        Thread.sleep(10000L);
        JobSchedulerStoreUsageTest.assertTrue((this.broker.getAdminView().getJobSchedulerStorePercentUsage() > 100 ? 1 : 0) != 0);
        this.broker.getAdminView().setJobSchedulerStoreLimit(0x2100000L);
        Thread.sleep(20000L);
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return producer.getSentCount() == producer.getMessageCount();
            }
        }, (long)40000L);
        JobSchedulerStoreUsageTest.assertEquals((String)"Producer didn't send all messages", (int)producer.getMessageCount(), (int)producer.getSentCount());
        LOG.info("Final scheduler usage: {}", (Object)this.broker.getAdminView().getJobSchedulerStorePercentUsage());
        JobSchedulerStoreUsageTest.assertTrue((this.broker.getAdminView().getJobSchedulerStorePercentUsage() < 100 ? 1 : 0) != 0);
    }
}

