/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jmx;

import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalMessageCountTest {
    private static final Logger LOG = LoggerFactory.getLogger(TotalMessageCountTest.class);
    private BrokerService brokerService;
    private final String TESTQUEUE = "testQueue";
    private ActiveMQConnectionFactory connectionFactory;
    private final String BROKER_ADDRESS = "tcp://localhost:0";
    private final ActiveMQQueue queue = new ActiveMQQueue("testQueue");
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        this.startBroker(true);
    }

    @After
    public void tearDown() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    @Test
    public void testNegativeTotalMessageCount() throws Exception {
        LOG.info("Running test testNegativeTotalMessageCount()");
        this.sendMessage();
        this.restartBroker();
        this.receiveMessage();
        long totalMessageCount = this.getTotalMessageCount();
        if (totalMessageCount < 0L) {
            LOG.error("Unexpected negative TotalMessageCount: " + totalMessageCount);
        } else {
            LOG.info("TotalMessageCount: " + totalMessageCount);
        }
        Assert.assertTrue((String)("Non negative TotalMessageCount " + totalMessageCount), (totalMessageCount > -1L ? 1 : 0) != 0);
        LOG.info("Test testNegativeTotalMessageCount() completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage() throws JMSException {
        Connection conn = this.connectionFactory.createConnection();
        try {
            conn.start();
            Session session = conn.createSession(false, 1);
            Queue queue = session.createQueue("testQueue");
            TextMessage msg = session.createTextMessage("This is a message.");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Destination)queue, (Message)msg);
            LOG.info("Message sent to testQueue");
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveMessage() throws JMSException {
        Connection conn = this.connectionFactory.createConnection();
        Message msg = null;
        try {
            conn.start();
            Session session = conn.createSession(false, 1);
            Queue queue = session.createQueue("testQueue");
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            msg = consumer.receive(TimeUnit.SECONDS.toMillis(10L));
            if (msg != null) {
                LOG.info("Message received from testQueue");
            }
            consumer.close();
            session.close();
        }
        finally {
            conn.close();
        }
        return msg;
    }

    private boolean restartBroker() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
        return this.startBroker(false);
    }

    private boolean startBroker(boolean deleteMessagesOnStartup) throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(true);
        this.brokerService.setDeleteAllMessagesOnStartup(deleteMessagesOnStartup);
        this.brokerService.setUseJmx(true);
        this.connectionUri = this.brokerService.addConnector("tcp://localhost:0").getPublishableConnectString();
        this.brokerService.start();
        this.connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        LOG.info("Broker started.");
        return true;
    }

    private long getTotalMessageCount() throws Exception {
        ObjectName brokerViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost");
        BrokerViewMBean brokerMBean = (BrokerViewMBean)this.brokerService.getManagementContext().newProxyInstance(brokerViewMBeanName, BrokerViewMBean.class, true);
        LOG.debug("Broker TotalMessageCount: " + brokerMBean.getTotalMessageCount());
        return brokerMBean.getTotalMessageCount();
    }
}

