/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InactiveDurableTopicTest
extends TestCase {
    private static final transient Logger LOG = LoggerFactory.getLogger(InactiveDurableTopicTest.class);
    private static final int MESSAGE_COUNT = 2000;
    private static final String DEFAULT_PASSWORD = "";
    private static final String USERNAME = "testuser";
    private static final String CLIENTID = "mytestclient";
    private static final String TOPIC_NAME = "testevent";
    private static final String SUBID = "subscription1";
    private static final int DELIVERY_MODE = 2;
    private static final int DELIVERY_PRIORITY = 4;
    private Connection connection;
    private MessageProducer publisher;
    private TopicSubscriber subscriber;
    private Topic topic;
    private Session session;
    private ActiveMQConnectionFactory connectionFactory;
    private BrokerService broker;

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.broker.addConnector("tcp://localhost:61616");
        this.broker.start();
        this.connectionFactory = new ActiveMQConnectionFactory("failover://tcp://localhost:61616");
        this.connectionFactory.setUseAsyncSend(true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.broker.stop();
    }

    public void test1CreateSubscription() throws Exception {
        try {
            this.connection = this.connectionFactory.createConnection(USERNAME, DEFAULT_PASSWORD);
            InactiveDurableTopicTest.assertNotNull((Object)this.connection);
            this.connection.setClientID(CLIENTID);
            this.connection.start();
            this.session = this.connection.createSession(false, 2);
            InactiveDurableTopicTest.assertNotNull((Object)this.session);
            this.topic = this.session.createTopic(TOPIC_NAME);
            InactiveDurableTopicTest.assertNotNull((Object)this.topic);
            this.subscriber = this.session.createDurableSubscriber(this.topic, SUBID, DEFAULT_PASSWORD, false);
            InactiveDurableTopicTest.assertNotNull((Object)this.subscriber);
            this.subscriber.close();
            this.session.close();
            this.connection.close();
        }
        catch (JMSException ex) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AssertionFailedError("Create Subscription caught: " + (Object)((Object)ex));
        }
    }

    public void test2ProducerTestCase() {
        try {
            int loop;
            this.connection = this.connectionFactory.createConnection(USERNAME, DEFAULT_PASSWORD);
            InactiveDurableTopicTest.assertNotNull((Object)this.connection);
            this.session = this.connection.createSession(false, 2);
            InactiveDurableTopicTest.assertNotNull((Object)this.session);
            this.topic = this.session.createTopic(TOPIC_NAME);
            InactiveDurableTopicTest.assertNotNull((Object)this.topic);
            this.publisher = this.session.createProducer((Destination)this.topic);
            InactiveDurableTopicTest.assertNotNull((Object)this.publisher);
            MapMessage msg = this.session.createMapMessage();
            InactiveDurableTopicTest.assertNotNull((Object)msg);
            msg.setString("key1", "value1");
            for (loop = 0; loop < 2000; ++loop) {
                msg.setInt("key2", loop);
                this.publisher.send((Message)msg, 2, 4, 0L);
                if (loop % 5000 != 0) continue;
                LOG.info("Sent " + loop + " messages");
            }
            InactiveDurableTopicTest.assertEquals((int)loop, (int)2000);
            this.publisher.close();
            this.session.close();
            this.connection.stop();
            this.connection.stop();
        }
        catch (JMSException ex) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AssertionFailedError("Create Subscription caught: " + (Object)((Object)ex));
        }
    }

    public void test3CreateSubscription() throws Exception {
        try {
            int loop;
            this.connection = this.connectionFactory.createConnection(USERNAME, DEFAULT_PASSWORD);
            InactiveDurableTopicTest.assertNotNull((Object)this.connection);
            this.connection.setClientID(CLIENTID);
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            InactiveDurableTopicTest.assertNotNull((Object)this.session);
            this.topic = this.session.createTopic(TOPIC_NAME);
            InactiveDurableTopicTest.assertNotNull((Object)this.topic);
            this.subscriber = this.session.createDurableSubscriber(this.topic, SUBID, DEFAULT_PASSWORD, false);
            InactiveDurableTopicTest.assertNotNull((Object)this.subscriber);
            for (loop = 0; loop < 2000; ++loop) {
                this.subscriber.receive();
                if (loop % 500 != 0) continue;
                LOG.debug("Received " + loop + " messages");
            }
            InactiveDurableTopicTest.assertEquals((int)loop, (int)2000);
            this.subscriber.close();
            this.session.close();
            this.connection.close();
        }
        catch (JMSException ex) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AssertionFailedError("Create Subscription caught: " + (Object)((Object)ex));
        }
    }
}

