/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ClientRebalanceTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = Logger.getLogger(ClientRebalanceTest.class);
    private static final String QUEUE_NAME = "Test.ClientRebalanceTest";

    @Override
    protected void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
    }

    public void testRebalance() throws Exception {
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/rebalance-broker1.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/rebalance-broker2.xml"));
        this.startAllBrokers();
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"b1")).broker.waitUntilStarted();
        LOG.info((Object)"Starting connection");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("failover:(tcp://localhost:61616,tcp://localhost:61617)?randomize=false");
        Connection conn = factory.createConnection();
        conn.start();
        Session session = conn.createSession(false, 1);
        Queue theQueue = session.createQueue(QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)theQueue);
        MessageConsumer consumer = session.createConsumer((Destination)theQueue);
        TextMessage message = session.createTextMessage("Test message");
        producer.send((Message)message);
        Message msg = consumer.receive(2000L);
        ClientRebalanceTest.assertNotNull((Object)msg);
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/rebalance-broker3.xml"));
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"b3")).broker.waitUntilStarted();
        Thread.sleep(3000L);
        LOG.info((Object)"Stopping broker 1");
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"b1")).broker.stop();
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"b1")).broker.waitUntilStopped();
        Thread.sleep(3000L);
        producer.send((Message)message);
        msg = consumer.receive(2000L);
        ClientRebalanceTest.assertNotNull((Object)msg);
        LOG.info((Object)"Stopping broker 2");
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"b2")).broker.stop();
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"b2")).broker.waitUntilStopped();
        producer.send((Message)message);
        msg = consumer.receive(2000L);
        ClientRebalanceTest.assertNotNull((Object)msg);
    }
}

