/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.activemq.transport.stomp.StompFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreeBrokerStompTemporaryQueueTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ThreeBrokerStompTemporaryQueueTest.class);
    private StompConnection stompConnection;

    @Override
    protected NetworkConnector bridgeBrokers(BrokerService localBroker, BrokerService remoteBroker, boolean dynamicOnly, int networkTTL, boolean conduit, boolean failover) throws Exception {
        List transportConnectors = remoteBroker.getTransportConnectors();
        if (!transportConnectors.isEmpty()) {
            URI remoteURI = ((TransportConnector)transportConnectors.get(0)).getConnectUri();
            DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI("static:" + remoteURI));
            connector.setName(localBroker.getBrokerName() + remoteBroker.getBrokerName());
            localBroker.addNetworkConnector((NetworkConnector)connector);
            maxSetupTime = 2000;
            return connector;
        }
        throw new Exception("Remote broker has no registered connectors.");
    }

    public void testStompTemporaryQueue() throws Exception {
        this.bridgeAndConfigureBrokers("BrokerA", "BrokerB");
        this.bridgeAndConfigureBrokers("BrokerA", "BrokerC");
        this.bridgeAndConfigureBrokers("BrokerB", "BrokerA");
        this.bridgeAndConfigureBrokers("BrokerB", "BrokerC");
        this.bridgeAndConfigureBrokers("BrokerC", "BrokerA");
        this.bridgeAndConfigureBrokers("BrokerC", "BrokerB");
        this.startAllBrokers();
        this.waitForBridgeFormation();
        Thread.sleep(1000L);
        this.stompConnection = new StompConnection();
        this.stompConnection.open("localhost", 61614);
        this.stompConnection.sendFrame("CONNECT\nlogin:system\npasscode:manager\n\n\u0000");
        StompFrame frame = this.stompConnection.receive();
        ThreeBrokerStompTemporaryQueueTest.assertTrue((boolean)frame.toString().startsWith("CONNECTED"));
        this.stompConnection.subscribe("/temp-queue/meaningless", "auto");
        this.stompConnection.send("/temp-queue/meaningless", "Hello World");
        frame = this.stompConnection.receive(3000L);
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Hello World", (String)frame.getBody());
        Thread.sleep(1000L);
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Destination", (int)1, (int)((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker.getAdminView().getTemporaryQueues().length);
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Destination", (int)1, (int)((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerB")).broker.getAdminView().getTemporaryQueues().length);
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Destination", (int)1, (int)((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerC")).broker.getAdminView().getTemporaryQueues().length);
        int advisoryTopicsForTempQueues = this.countTopicsByName("BrokerA", "ActiveMQ.Advisory.Consumer.Queue.ID");
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Advisory topic should be present", (int)1, (int)advisoryTopicsForTempQueues);
        advisoryTopicsForTempQueues = this.countTopicsByName("BrokerB", "ActiveMQ.Advisory.Consumer.Queue.ID");
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Advisory topic should be present", (int)1, (int)advisoryTopicsForTempQueues);
        advisoryTopicsForTempQueues = this.countTopicsByName("BrokerC", "ActiveMQ.Advisory.Consumer.Queue.ID");
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Advisory topic should be present", (int)1, (int)advisoryTopicsForTempQueues);
        this.stompConnection.disconnect();
        Thread.sleep(1000L);
        advisoryTopicsForTempQueues = this.countTopicsByName("BrokerA", "ActiveMQ.Advisory.Consumer.Queue.ID");
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Advisory topic should have been deleted", (int)0, (int)advisoryTopicsForTempQueues);
        advisoryTopicsForTempQueues = this.countTopicsByName("BrokerB", "ActiveMQ.Advisory.Consumer.Queue.ID");
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Advisory topic should have been deleted", (int)0, (int)advisoryTopicsForTempQueues);
        advisoryTopicsForTempQueues = this.countTopicsByName("BrokerC", "ActiveMQ.Advisory.Consumer.Queue.ID");
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Advisory topic should have been deleted", (int)0, (int)advisoryTopicsForTempQueues);
        LOG.info("Restarting brokerA");
        JmsMultipleBrokersTestSupport.BrokerItem brokerItem = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.remove("BrokerA");
        if (brokerItem != null) {
            brokerItem.destroy();
        }
        BrokerService restartedBroker = this.createAndConfigureBroker(new URI("broker:(tcp://localhost:61616,stomp://localhost:61613)/BrokerA"));
        this.bridgeAndConfigureBrokers("BrokerA", "BrokerB");
        this.bridgeAndConfigureBrokers("BrokerA", "BrokerC");
        restartedBroker.start();
        this.waitForBridgeFormation();
        Thread.sleep(3000L);
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Destination", (int)0, (int)((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker.getAdminView().getTemporaryQueues().length);
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Destination", (int)0, (int)((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerB")).broker.getAdminView().getTemporaryQueues().length);
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Destination", (int)0, (int)((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerC")).broker.getAdminView().getTemporaryQueues().length);
        advisoryTopicsForTempQueues = this.countTopicsByName("BrokerA", "ActiveMQ.Advisory.Consumer.Queue.ID");
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Advisory topic should have been deleted", (int)0, (int)advisoryTopicsForTempQueues);
        advisoryTopicsForTempQueues = this.countTopicsByName("BrokerB", "ActiveMQ.Advisory.Consumer.Queue.ID");
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Advisory topic should have been deleted", (int)0, (int)advisoryTopicsForTempQueues);
        advisoryTopicsForTempQueues = this.countTopicsByName("BrokerC", "ActiveMQ.Advisory.Consumer.Queue.ID");
        ThreeBrokerStompTemporaryQueueTest.assertEquals((String)"Advisory topic should have been deleted", (int)0, (int)advisoryTopicsForTempQueues);
    }

    private int countTopicsByName(String broker, String name) throws Exception {
        int advisoryTopicsForTempQueues = 0;
        for (int i = 0; i < ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)broker)).broker.getAdminView().getTopics().length; ++i) {
            if (!((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)broker)).broker.getAdminView().getTopics()[i].toString().contains(name)) continue;
            ++advisoryTopicsForTempQueues;
        }
        return advisoryTopicsForTempQueues;
    }

    private void bridgeAndConfigureBrokers(String local, String remote) throws Exception {
        NetworkConnector bridge = this.bridgeBrokers(local, remote);
        ThreeBrokerStompTemporaryQueueTest.assertNotNull((Object)bridge);
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        String options = new String("?deleteAllMessagesOnStartup=true");
        this.createAndConfigureBroker(new URI("broker:(tcp://localhost:61616,stomp://localhost:61613)/BrokerA" + options));
        this.createAndConfigureBroker(new URI("broker:(tcp://localhost:61617,stomp://localhost:61614)/BrokerB" + options));
        this.createAndConfigureBroker(new URI("broker:(tcp://localhost:61618,stomp://localhost:61615)/BrokerC" + options));
    }

    private BrokerService createAndConfigureBroker(URI uri) throws Exception {
        BrokerService broker = this.createBroker(uri);
        this.configurePersistenceAdapter(broker);
        return broker;
    }

    protected void configurePersistenceAdapter(BrokerService broker) throws IOException {
        File dataFileDir = new File("target/test-amq-data/kahadb/" + broker.getBrokerName());
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(dataFileDir);
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
    }
}

