/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerThread.class);
    int messageCount = 1000;
    Destination dest;
    protected Session sess;
    int sleep = 0;
    int sentCount = 0;

    public ProducerThread(Session sess, Destination dest) {
        this.dest = dest;
        this.sess = sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MessageProducer producer = null;
        try {
            producer = this.sess.createProducer(this.dest);
            this.sentCount = 0;
            while (this.sentCount < this.messageCount) {
                producer.send(this.createMessage(this.sentCount));
                LOG.info("Sent 'test message: " + this.sentCount + "'");
                if (this.sleep > 0) {
                    Thread.sleep(this.sleep);
                }
                ++this.sentCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected Message createMessage(int i) throws Exception {
        return this.sess.createTextMessage("test message: " + i);
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public int getSentCount() {
        return this.sentCount;
    }
}

